/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import cn.omisheep.commons.util.RSAUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;

public class RsaHelper {
    public static RsaKeyPair genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
        String privateKeyString = new String(Base64.encodeBase64((byte[])privateKey.getEncoded()));
        return new RsaKeyPair(publicKeyString, privateKeyString);
    }

    public static String encrypt(String str, String publicKey) {
        try {
            return RSAUtils.encryptString(RSAUtils.getPublicKey(publicKey), str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String decrypt(String str, String privateKey) {
        try {
            return RSAUtils.decryptString(RSAUtils.getPrivateKey(privateKey), RsaHelper.bugfix(str));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String bugfix(String text) {
        return text.replaceAll(" ", "+");
    }

    public static class RsaKeyPair {
        private final String publicKey;
        private final String privateKey;

        public RsaKeyPair(String publicKey, String privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String toString() {
            return "\npublicKey=\n" + this.publicKey + "\nprivateKey=\n" + this.privateKey;
        }
    }
}

