/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CollectionUtils {
    public static <T> boolean isEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> list) {
        return !CollectionUtils.isEmpty(list);
    }

    public static <T> Set<T> newSet(T ... vals) {
        return CollectionUtils.ofSet(vals);
    }

    public static <T> Set<T> ofSet(T ... vals) {
        HashSet<String> set = new HashSet<String>();
        if (vals instanceof String[]) {
            String[] strings;
            for (String val : strings = (String[])vals) {
                if (val == null) continue;
                set.add(val.trim());
            }
        } else {
            set.addAll(Arrays.asList(vals));
        }
        return set;
    }

    public static String resolveSingletonSet(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    public static Set<String> singletonSet(String val) {
        return new HashSet<String>(Collections.singletonList(val));
    }

    public static Set<Set<String>> splitStrValsToSets(String separator, String ... value) {
        HashSet<Set<String>> ret = new HashSet<Set<String>>();
        for (String val : CollectionUtils.newSet(value)) {
            ret.add(CollectionUtils.newSet(val.split(separator)));
        }
        return ret.size() > 0 ? ret : null;
    }

    public static <T> boolean containsSub(Set<Set<T>> sets, List<T> list) {
        if (list == null) {
            return false;
        }
        return CollectionUtils.containsSub(sets, new HashSet<T>(list));
    }

    public static <T> boolean containsSub(Set<Set<T>> sets, Set<T> set) {
        if (set == null) {
            return false;
        }
        return Objects.requireNonNull(sets).stream().anyMatch(s -> {
            for (Object t : s) {
                if (set.contains(t)) continue;
                return false;
            }
            return true;
        });
    }
}

