/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import cn.omisheep.commons.util.StringUtils;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        Class<?> cls;
        try {
            cls = Class.forName(className, isInitialized, ClassUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error("load class failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return cls;
    }

    public static Class<?> loadClass(String className) {
        return ClassUtils.loadClass(className, true);
    }

    public static Set<Class<?>> getClassSet(String packageName) {
        HashSet classSet = new HashSet();
        try {
            Enumeration<URL> urls = ClassUtils.getClassLoader().getResources(packageName.replace(".", "/"));
            while (urls.hasMoreElements()) {
                JarFile jarFile;
                JarURLConnection jarURLConnection;
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath().replaceAll("%20", " ");
                    ClassUtils.addClass(classSet, packagePath, packageName);
                    continue;
                }
                if (!protocol.equals("jar") || (jarURLConnection = (JarURLConnection)url.openConnection()) == null || (jarFile = jarURLConnection.getJarFile()) == null) continue;
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    ClassUtils.doAddClass(classSet, className);
                }
            }
        }
        catch (Exception e) {
            log.error("get class set failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return classSet;
    }

    private static void addClass(Set<Class<?>> classSet, String packagePath, String packageName) {
        File[] files = new File(packagePath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || file.isDirectory());
        if (files != null) {
            for (File file2 : files) {
                String fileName = file2.getName();
                if (file2.isFile()) {
                    String className = fileName.substring(0, fileName.lastIndexOf("."));
                    if (!StringUtils.isEmpty(packageName)) {
                        className = packageName + "." + className;
                    }
                    ClassUtils.doAddClass(classSet, className);
                    continue;
                }
                String subPackagePath = fileName;
                if (!StringUtils.isEmpty(packagePath)) {
                    subPackagePath = packagePath + "/" + subPackagePath;
                }
                String subPackageName = fileName;
                if (!StringUtils.isEmpty(packageName)) {
                    subPackageName = packageName + "." + subPackageName;
                }
                ClassUtils.addClass(classSet, subPackagePath, subPackageName);
            }
        }
    }

    private static void doAddClass(Set<Class<?>> classSet, String className) {
        Class<?> cls = ClassUtils.loadClass(className, false);
        classSet.add(cls);
    }

    public static Class<?> getInterfaceT(Object o, int index) {
        Type[] types = o.getClass().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)types[index];
        Type type = parameterizedType.getActualTypeArguments()[index];
        return ClassUtils.checkType(type, index);
    }

    public static Class<?> getClassT(Object o, int index) {
        Type type = o.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type actType = parameterizedType.getActualTypeArguments()[index];
            return ClassUtils.checkType(actType, index);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, but <" + type + "> is of type " + className);
    }

    private static Class<?> checkType(Type type, int index) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type t = pt.getActualTypeArguments()[index];
            return ClassUtils.checkType(t, index);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, but <" + type + "> is of type " + className);
    }
}

