/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;

public class CapacityRestrictedQueue<E>
extends LinkedList<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = -513422014711150344L;
    private int maxCapacity = 10;

    public CapacityRestrictedQueue() {
    }

    public CapacityRestrictedQueue(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    private int overflowCapacity() {
        return Math.max(this.size() - this.maxCapacity, 0);
    }

    private void stable(boolean l2b) {
        for (int i = 0; i < this.overflowCapacity(); ++i) {
            if (l2b) {
                this.pollLast();
                continue;
            }
            this.pollFirst();
        }
    }

    @Override
    public boolean offer(E e) {
        super.offer(e);
        this.stable(false);
        return true;
    }

    @Override
    public boolean offerFirst(E e) {
        super.offerFirst(e);
        this.stable(true);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        super.offerLast(e);
        this.stable(false);
        return true;
    }

    @Override
    public void addFirst(E e) {
        super.addFirst(e);
        this.stable(true);
    }

    @Override
    public void addLast(E e) {
        super.addLast(e);
        this.stable(false);
    }

    @Override
    public boolean add(E e) {
        super.add(e);
        this.stable(false);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        super.addAll(c);
        this.stable(false);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        super.addAll(index, c);
        this.stable(false);
        return true;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.stable(false);
    }
}

