/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static long parseTimeValueTotal(String ... timeVals) {
        long c = 0L;
        for (String timeVal : timeVals) {
            c += TimeUtils.parseTimeValue(timeVal);
        }
        return c;
    }

    public static long parseTimeValue(String timeVal) {
        return TimeUtils.parseTimeValue(timeVal, " ");
    }

    public static long parseTimeValueToSecond(String timeVal) {
        return TimeUnit.MILLISECONDS.toSeconds(TimeUtils.parseTimeValue(timeVal, " "));
    }

    public static long parseTimeValue(String timeVal, String delimiter) {
        if (timeVal == null || timeVal.equals("") || timeVal.equals("0")) {
            return 0L;
        }
        String[] s = timeVal.trim().split(delimiter);
        long time = 0L;
        for (String val : s) {
            time += TimeUtils.parseTime(val);
        }
        return time;
    }

    public static String parseTime(long ms) {
        return TimeUtils.parseTime(ms, " ");
    }

    public static String parseTime(long ms, String delimiter) {
        String _ms = ms % 1000L + "ms";
        if (ms < 1000L) {
            return _ms;
        }
        long s = ms / 1000L;
        String _s = s % 60L + "s" + delimiter + _ms;
        if (s < 60L) {
            return _s;
        }
        long m = s / 60L;
        String _m = m % 60L + "m" + delimiter + _s;
        if (m < 60L) {
            return _m;
        }
        long h = m / 60L;
        String _h = h % 60L + "h" + delimiter + _m;
        if (h < 24L) {
            return _h;
        }
        long d = h / 24L;
        return d + "d" + delimiter + _h;
    }

    private static long parseTime(String timeVal) {
        String normalized = timeVal.toLowerCase(Locale.ROOT).trim();
        if (normalized.endsWith("d")) {
            return TimeUnit.DAYS.toMillis(TimeUtils.parse(normalized, "d"));
        }
        if (normalized.endsWith("h")) {
            return TimeUnit.HOURS.toMillis(TimeUtils.parse(normalized, "h"));
        }
        if (normalized.endsWith("m")) {
            return TimeUnit.MINUTES.toMillis(TimeUtils.parse(normalized, "m"));
        }
        if (normalized.endsWith("ms")) {
            return TimeUnit.MILLISECONDS.toMillis(TimeUtils.parse(normalized, "ms"));
        }
        if (normalized.endsWith("s")) {
            return TimeUnit.SECONDS.toMillis(TimeUtils.parse(normalized, "s"));
        }
        return 0L;
    }

    private static long parse(String normalized, String suffix) {
        String s = normalized.substring(0, normalized.length() - suffix.length()).trim();
        try {
            long value = Long.parseLong(s);
            if (value >= 0L) {
                return value;
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return 0L;
    }

    public static long nowTime() {
        return TimeUtils.now().getTime();
    }

    public static Date now() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime nowDateTime() {
        return LocalDateTime.now();
    }

    public static String nowString() {
        return TimeUtils.format(TimeUtils.now());
    }

    public static String nowString(String pattern) {
        return TimeUtils.format(pattern, TimeUtils.now());
    }

    public static Date datePlus(Date date, String plusTimeVal) {
        return TimeUtils.datePlus(date, TimeUtils.parseTimeValue(plusTimeVal));
    }

    public static Date datePlus(Date date, long plusTime) {
        return Date.from(date.toInstant().plus(plusTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date plus(String plusTimeVal) {
        return TimeUtils.plus(TimeUtils.parseTimeValue(plusTimeVal));
    }

    public static Date plus(long plusTimeVak) {
        return Date.from(TimeUtils.nowPlus(plusTimeVak).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date dateMinus(Date date, String minusTimeVal) {
        return TimeUtils.dateMinus(date, TimeUtils.parseTimeValue(minusTimeVal));
    }

    public static Date dateMinus(Date date, long minusTime) {
        return Date.from(date.toInstant().minus(minusTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date minus(long minusTimeVal) {
        return Date.from(TimeUtils.nowMinus(minusTimeVal).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date minus(String minusTimeVal) {
        return TimeUtils.minus(TimeUtils.parseTimeValue(minusTimeVal));
    }

    public static String format(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String format(String pattern, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static int maxDaysInMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        return cal.getActualMaximum(5);
    }

    public static int[] currentYearAndMonth() {
        LocalDateTime now = LocalDateTime.now();
        return new int[]{now.getYear(), now.getMonthValue()};
    }

    public static int[] yesterdayYearAndMonth() {
        LocalDateTime localDateTime = TimeUtils.nowMinus("1d");
        return new int[]{localDateTime.getYear(), localDateTime.getMonthValue()};
    }

    public static int currentYear() {
        return LocalDateTime.now().getYear();
    }

    public static int currentMonth() {
        return LocalDateTime.now().getMonthValue();
    }

    public static int currentDay() {
        return LocalDateTime.now().getDayOfMonth();
    }

    public static int currentHour() {
        return LocalDateTime.now().getHour();
    }

    public static int currentMinute() {
        return LocalDateTime.now().getMinute();
    }

    public static LocalDateTime nowPlus(long plusTime) {
        return LocalDateTime.now().plus(plusTime, ChronoUnit.MILLIS);
    }

    public static LocalDateTime nowPlus(String plusTimeVal) {
        return LocalDateTime.now().plus(TimeUtils.parseTimeValue(plusTimeVal), ChronoUnit.MILLIS);
    }

    public static LocalDateTime nowMinus(long minusTime) {
        return LocalDateTime.now().minus(minusTime, ChronoUnit.MILLIS);
    }

    public static LocalDateTime nowMinus(String minusTimeVal) {
        return LocalDateTime.now().minus(TimeUtils.parseTimeValue(minusTimeVal), ChronoUnit.MILLIS);
    }

    public static Date nextIntactDateForMinute() {
        Calendar ca = Calendar.getInstance();
        ca.set(13, 0);
        ca.set(14, 0);
        ca.add(12, 1);
        return ca.getTime();
    }

    public static Date nextIntactDateForDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(10, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        ca.add(5, 1);
        return ca.getTime();
    }
}

