/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class BufferedServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] buffer;

    public BufferedServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        int read;
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((read = is.read(buff)) > 0) {
            baos.write(buff, 0, read);
        }
        this.buffer = baos.toByteArray();
    }

    public ServletInputStream getInputStream() {
        return new BufferedServletInputStream(this.buffer);
    }

    public static class BufferedServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public BufferedServletInputStream(byte[] buffer) {
            this.inputStream = new ByteArrayInputStream(buffer);
        }

        public int available() {
            return this.inputStream.available();
        }

        public int read() {
            return this.inputStream.read();
        }

        public int read(byte[] b, int off, int len) {
            return this.inputStream.read(b, off, len);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

