package cn.omisheep.commons.web.entity;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusCode {

    public static final StatusCode SUCCESS = of(true, 100, "success");
    public static final StatusCode OK = of(true, 100, "OK");

    public static final StatusCode FAIL = of(false, -100, "OK");

    public static final StatusCode SERVER_ERROR = of(false, -9999, "服务器繁忙");

    boolean success;
    int code;
    String message;

    protected StatusCode(boolean success, int code, String message) {
        this.success = success;
        this.code = code;
        this.message = message;
    }

    protected static StatusCode of(boolean success, int code, String message) {
        return new StatusCode(success, code, message);
    }

}
