package cn.omisheep.commons.web.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.0
 * @since 1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Result {

    boolean success;
    int code;
    String message;

    Object data;

    public ResultMap data(String key, Object data) {
        return new ResultMap(success, code, message).data(key, data);
    }

    public Result data(Object data) {
        this.data = data;
        return this;
    }

    protected Result(StatusCode statusCode, Object data) {
        this.success = statusCode.success;
        this.code = statusCode.code;
        this.message = statusCode.message;
        this.data = data;
    }

    public static Result of(StatusCode statusCode, Object data) {
        return new Result(statusCode, data);
    }

    public static Result of(StatusCode statusCode) {
        return new Result(statusCode, null);
    }


    public static Result of(boolean success, int code, String message, Object data) {
        return new Result(StatusCode.of(success, code, message), data);
    }

    public static Result of(boolean success, int code, String message) {
        return new Result(StatusCode.of(success, code, message), null);
    }


}
