package cn.omisheep.commons.util;

import com.alibaba.fastjson.JSONObject;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.0
 * @since 1.0.0
 */
public class HttpUtils {
    /**
     * @return 当前线程的request
     */
    public static HttpServletRequest getCurrentRequest() {
        return ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
    }

    /**
     * @return 当前线程的response
     */
    public static HttpServletResponse getCurrentResponse() {
        return ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getResponse();
    }

    /**
     * 读取当前request中对应名字的值的一个cookie
     *
     * @param name cookie name
     * @return cookie
     */
    public static Cookie readSingleCookieInRequestByName(String name) {
        Cookie[] cookies = getCurrentRequest().getCookies();
        if (cookies == null) return null;
        return Arrays.stream(cookies)
                .filter(cookie -> name.equals(cookie.getName()))
                .findFirst().orElse(null);
    }

    public static void returnResponse(int status, Object object) throws IOException {
        HttpServletResponse response = getCurrentResponse();
        if (response == null) return;
        response.setStatus(status);
        response.getWriter().write(JSONObject.toJSONString(object));
    }

    public static void returnResponse(int status) throws IOException {
        HttpServletResponse response = getCurrentResponse();
        if (response == null) return;
        response.setStatus(status);
    }
}
