/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.autt.core.browser;

import cn.omisheep.autt.Connect;
import cn.omisheep.autt.Response;
import cn.omisheep.autt.core.Cookies;
import cn.omisheep.autt.core.browser.ResultObject;
import java.util.List;
import java.util.Map;

public class BrowserResponse
implements Response {
    private final Map<String, List<String>> header;
    private final ResultObject resultObject;
    private final Cookies cookies;
    private final int responseCode;
    private final Connect connect;

    BrowserResponse(Connect connect, Map<String, List<String>> header, ResultObject resultObject, Cookies cookies, int responseCode) {
        this.connect = connect;
        this.resultObject = resultObject;
        this.header = header;
        this.cookies = cookies;
        this.responseCode = responseCode;
    }

    @Override
    public String getBody() {
        return this.resultObject.toString();
    }

    @Override
    public byte[] getBodyBytes() {
        return this.resultObject.toBytes();
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public Connect getConnect() {
        return this.connect;
    }

    @Override
    public Map<String, List<String>> getHeader() {
        return this.header;
    }

    @Override
    public String getHeader(String name) {
        return this.header.get(name).get(this.header.size() - 1);
    }

    @Override
    public Cookies getCookies() {
        return this.cookies;
    }

    @Override
    public String getCookieVal(String name) {
        return (String)this.cookies.get(name);
    }

    public String toString() {
        return this.getBody();
    }
}

