/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.autt.core.browser;

import cn.omisheep.autt.Autt;
import cn.omisheep.autt.Connect;
import cn.omisheep.autt.GetRequest;
import cn.omisheep.autt.PostRequest;
import cn.omisheep.autt.Request;
import cn.omisheep.autt.core.Cookies;
import cn.omisheep.autt.core.Method;
import cn.omisheep.autt.core.browser.BrowserRequest;
import cn.omisheep.autt.util.SerializeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BrowserConnect
implements Connect {
    private Map<String, Map<String, Cookies>> cookies = new HashMap<String, Map<String, Cookies>>();
    int connTimeout = 30000;
    int readTimeout = 30000;
    private String context = "";

    @Override
    public GetRequest get(String url) {
        return (GetRequest)this.generagteRequest(url, Method.GET);
    }

    @Override
    public GetRequest get(String url, Object param) {
        return this.get(url).param(param);
    }

    @Override
    public PostRequest post(String url) {
        return (PostRequest)this.generagteRequest(url, Method.POST);
    }

    @Override
    public Connect connTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    @Override
    public Connect readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private Request generagteRequest(String url, Method method) {
        if (url.startsWith("http")) {
            return new BrowserRequest(this, url, method);
        }
        if (this.context == null || this.context.equals("")) {
            return new BrowserRequest(this, Autt.getContext() + url, method);
        }
        return new BrowserRequest(this, this.context + url, method);
    }

    @Override
    public Connect setContext(String context) {
        this.context = context;
        return this;
    }

    @Override
    public List<Cookies> getCookiesListByUri(String domain, String uri) {
        ArrayList<Cookies> list = new ArrayList<Cookies>();
        for (Map.Entry<String, Map<String, Cookies>> entry : this.cookies.entrySet()) {
            if (!domain.endsWith(entry.getKey())) continue;
            Optional.ofNullable(entry.getValue()).ifPresent(v -> {
                for (Map.Entry entry2 : v.entrySet()) {
                    if (!uri.startsWith((String)entry2.getKey())) continue;
                    list.add((Cookies)entry2.getValue());
                }
            });
        }
        return list;
    }

    @Override
    public Cookies getCookiesByDomainAndPath(String domain, String path) {
        return this.cookies.get(Objects.requireNonNull(domain, "domain must not null")).get(Objects.requireNonNull(path, "path must not null"));
    }

    @Override
    public String getCookieVal(String domain, String uri, String cookieName) {
        List<Cookies> cookie = this.getCookiesListByUri(domain, uri);
        Iterator<Cookies> iterator = cookie.iterator();
        if (iterator.hasNext()) {
            Cookies c = iterator.next();
            Map.Entry entry = c.entrySet().stream().filter(e -> ((String)e.getKey()).equals(cookieName)).findFirst().orElse(null);
            return (String)entry.getValue();
        }
        return null;
    }

    public void setCookie(String domain, String path, Cookies cookie) {
        Map map;
        Cookies c;
        if (domain.startsWith(".")) {
            domain = domain.substring(1);
        }
        if ((c = (Cookies)(map = this.cookies.computeIfAbsent(domain, k -> new HashMap())).get(path)) == null) {
            map.put(path, cookie);
        } else {
            c.putAll(cookie);
        }
    }

    @Override
    public String saveCookie() {
        return SerializeUtil.serializationObjectByJson(this.cookies);
    }

    @Override
    public Connect initCookie(String saveCookies) {
        if (saveCookies == null || saveCookies.equals("")) {
            return this;
        }
        this.cookies = (Map)SerializeUtil.deserializationObjectByJson(saveCookies);
        return this;
    }
}

