/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.autt.core.browser;

import cn.omisheep.autt.Connect;
import cn.omisheep.autt.GetRequest;
import cn.omisheep.autt.PostRequest;
import cn.omisheep.autt.Request;
import cn.omisheep.autt.Response;
import cn.omisheep.autt.core.ContentType;
import cn.omisheep.autt.core.Cookies;
import cn.omisheep.autt.core.Method;
import cn.omisheep.autt.core.RequestHeader;
import cn.omisheep.autt.core.browser.BrowserConnect;
import cn.omisheep.autt.core.browser.BrowserResponse;
import cn.omisheep.commons.util.InputStreamCacher;
import cn.omisheep.commons.util.charset.detector.CharsetDetector;
import cn.omisheep.commons.util.web.ConvertUtil;
import cn.omisheep.commons.util.web.URLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BrowserRequest
implements GetRequest,
PostRequest {
    private int connTimeout;
    private int readTimeout;
    private Charset charset;
    private Object body;
    private final Method method;
    private final String domain;
    private final String uri;
    private final String path;
    private final Map<String, String> param = new HashMap<String, String>();
    private final RequestHeader header = new RequestHeader();
    private final Cookies cookies = new Cookies();
    private final BrowserConnect connect;

    BrowserRequest(BrowserConnect connect, String url, Method method) {
        this.method = method;
        this.connect = connect;
        URLParser.URLInfo urlInfo = URLParser.parse((String)url);
        this.domain = urlInfo.getDomain();
        this.uri = urlInfo.getUri();
        this.path = urlInfo.getPath();
        this.param.putAll(urlInfo.getParam());
        List<Cookies> cookies = connect.getCookiesListByUri(this.domain, this.uri);
        if (cookies != null) {
            this.cookies.putList(cookies);
        }
        this.connTimeout = connect.connTimeout;
        this.readTimeout = connect.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response send() {
        HttpURLConnection conn = null;
        try {
            conn = this.requestConfig();
            List<String> list = conn.getHeaderFields().get("Set-Cookie");
            Cookies coo = new Cookies();
            if (list != null) {
                for (String s : list) {
                    Cookies c = new Cookies();
                    String[] split = s.replaceAll(" ", "").split(";");
                    String _domain = this.domain;
                    String _path = this.uri;
                    for (int i = 0; i < split.length; ++i) {
                        String[] s1 = split[i].split("=");
                        if (i == 0) {
                            c.put(s1[0], s1[1]);
                            continue;
                        }
                        if (s1[0].equals("Domain")) {
                            _domain = s1[1];
                            continue;
                        }
                        if (!s1[0].equals("Path")) continue;
                        _path = s1[1];
                    }
                    coo.putAll(c);
                    this.connect.setCookie(_domain, _path, c);
                }
            }
            BrowserResponse browserResponse = new BrowserResponse(this.connect, conn.getHeaderFields(), this.readResponseBody(conn), coo, conn.getResponseCode());
            return browserResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            Response response = null;
            return response;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public Connect getConnect() {
        return this.connect;
    }

    @Override
    public Request cookie(String key, String val) {
        this.cookies.put(key, val);
        return this;
    }

    @Override
    public Request cookies(Cookies cookies) {
        this.cookies.putAll(cookies);
        return this;
    }

    @Override
    public Request header(String key, String val) {
        this.header.put(key, val);
        return this;
    }

    @Override
    public Request header(Map<String, String> header) {
        this.header.putAll((Map<? extends String, ? extends String>)header);
        return this;
    }

    @Override
    public Request userAgent(String userAgent) {
        return this.header("User-Agent", userAgent);
    }

    @Override
    public PostRequest body(Object o, ContentType contentType) {
        this.body = o;
        return this.contentType(contentType);
    }

    @Override
    public PostRequest body(Object o) {
        this.body = o;
        return this;
    }

    @Override
    public PostRequest contentType(ContentType contentType) {
        this.header.setContentType(contentType);
        return this;
    }

    @Override
    public GetRequest param(Object param) {
        if (param == null) {
            return this;
        }
        ConvertUtil.objectToMap((Object)param, this.param);
        return this;
    }

    @Override
    public GetRequest param(String key, Object val) {
        if (val != null) {
            this.param.put(key, val.toString());
        } else {
            this.param.put(key, "");
        }
        return this;
    }

    @Override
    public Request connTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    @Override
    public Request readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Request charset(String charset) {
        this.charset = Charset.forName(charset);
        return this;
    }

    @Override
    public Request charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public String toString() {
        return this.send().toString();
    }

    private HttpURLConnection openConnection() throws IOException {
        URL realUrl = new URL(this.getURL());
        return (HttpURLConnection)realUrl.openConnection();
    }

    private HttpURLConnection requestConfig() throws IOException {
        HttpURLConnection conn = this.openConnection();
        conn.setConnectTimeout(this.connTimeout);
        conn.setReadTimeout(this.readTimeout);
        for (Map.Entry entry : this.header.entrySet()) {
            conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        conn.setRequestProperty("Cookie", this.cookies.toPropertyString());
        if (this.header.getContentType() != null) {
            String type = this.header.getContentType().getCt();
            if (this.charset != null) {
                type = type + ";charset=" + this.charset;
            }
            conn.setRequestProperty("Content-Type", type);
        }
        conn.setRequestMethod(this.method.name());
        if (this.method.hasBody()) {
            String _body = this.parseBody();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Length", _body.length() + "");
            PrintWriter out = new PrintWriter(conn.getOutputStream());
            out.print(_body);
            out.flush();
            out.close();
        }
        return conn;
    }

    private String readResponseBody(HttpURLConnection conn) throws IOException {
        int len;
        String[] split;
        InputStreamCacher inputStreamCacher;
        if (conn == null) {
            return "";
        }
        StringBuilder resultBody = new StringBuilder();
        Charset _charset = null;
        try {
            inputStreamCacher = new InputStreamCacher(conn.getInputStream());
        }
        catch (IOException e) {
            inputStreamCacher = new InputStreamCacher(conn.getErrorStream());
        }
        String contentType = conn.getHeaderFields().get("Content-Type").get(0);
        for (String v : split = contentType.split(";")) {
            String _v = v.trim();
            if (!_v.startsWith("charset")) continue;
            _charset = Charset.forName(_v.split("=")[1]);
        }
        if (_charset == null) {
            InputStream charsetInputStream = inputStreamCacher.getInputStream();
            _charset = CharsetDetector.detect((InputStream)charsetInputStream);
            charsetInputStream.close();
        }
        InputStream in = inputStreamCacher.getInputStream();
        byte[] buffer = new byte[512];
        while ((len = in.read(buffer)) > -1) {
            resultBody.append(new String(buffer, 0, len, _charset));
        }
        in.close();
        if (resultBody.length() > 0) {
            resultBody.deleteCharAt(resultBody.length() - 1);
        }
        return resultBody.toString();
    }

    private String parseBody() {
        if (this.body == null) {
            return "";
        }
        ContentType contentType = this.header.getContentType();
        if (contentType == null) {
            try {
                throw new Exception("Content-Type is null");
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        if (this.body instanceof String) {
            return (String)this.body;
        }
        try {
            if (contentType.equals((Object)ContentType.JSON)) {
                return ConvertUtil.objectToJSON((Object)this.body);
            }
            if (contentType.equals((Object)ContentType.X_WWW_FORM_URLENCODED)) {
                return ConvertUtil.objectToForm((Object)this.body);
            }
            throw new Exception("content-type mismatch");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getURL() {
        if (this.param.isEmpty()) {
            return this.path;
        }
        return this.path + "?" + ConvertUtil.objectToForm(this.param);
    }
}

