/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.autt.core;

import cn.omisheep.autt.core.ContentType;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class RequestHeader
extends HashMap<String, String> {
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT = "Accept";
    private static String DEF_USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 11_0_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36";
    private static String DEF_ACCEPT = "*/*";
    private ContentType contentType;
    private Charset charset;

    public ContentType getContentType() {
        return this.contentType;
    }

    public RequestHeader setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public static void setDefUserAgent(String defUserAgent) {
        DEF_USER_AGENT = defUserAgent;
    }

    public static void setDefAccept(String defAccept) {
        DEF_ACCEPT = defAccept;
    }

    public RequestHeader() {
        this.put(USER_AGENT, DEF_USER_AGENT);
        this.put(ACCEPT, DEF_ACCEPT);
    }

    @Override
    public String put(String key, String value) {
        this.check(key);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        m.keySet().forEach(this::check);
        super.putAll(m);
    }

    private void check(String key) {
        if (USER_AGENT.equalsIgnoreCase(key)) {
            this.remove(USER_AGENT);
        }
        if (ACCEPT.equalsIgnoreCase(key)) {
            this.remove(ACCEPT);
        }
    }
}

