package cn.omisheep.autt;

import cn.omisheep.autt.core.Cookies;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Consumer;

public interface Request {

    Response send();

    Connect getConnect();

    default Connect then() {
        send();
        return getConnect();
    }

    default Connect then(Consumer<Response> callback) {
        callback.accept(send());
        return getConnect();
    }

    default Connect then(Consumer<Response> onSuccess, Consumer<Response> onFail) {
        Response response = send();
        if (response.getResponseCode() == 200) onSuccess.accept(response);
        else onFail.accept(response);
        return getConnect();
    }

    Request cookie(String key, String val);

    Request cookies(Cookies cookies);

    Request header(String key, String val);

    Request header(Map<String, String> header);

    Request userAgent(String userAgent);

    Request connTimeout(int connTimeout);

    Request readTimeout(int readTimeout);

    Request charset(String charset);

    Request charset(Charset charset);

}
