package cn.omisheep.autt;

import cn.omisheep.autt.core.ContentType;
import cn.omisheep.autt.core.Cookies;

import java.util.List;

public interface Connect {

    int defaultConnTimeout = 30000;

    int defaultReadTimeout = 30000;

    GetRequest get(String url);

    GetRequest get(String url, Object param);

    PostRequest post(String url);

    default PostRequest post(String url, Object body) {
        return post(url).body(body);
    }

    default PostRequest post(String url, Object body, ContentType contentType) {
        return post(url).body(body, contentType);
    }

    Connect connTimeout(int connTimeout);

    Connect readTimeout(int readTimeout);

    Connect setContext(String context);

    List<Cookies> getCookiesListByUri(String domain, String uri);

    Cookies getCookiesByDomainAndPath(String domain, String path);

    String getCookieVal(String domain, String uri, String cookieName);

    String saveCookie();

    Connect initCookie(String saveCookies);

}
