package cn.omisheep.autt.core.browser;

import cn.omisheep.autt.Connect;
import cn.omisheep.autt.Response;
import cn.omisheep.autt.core.Cookies;

import java.util.List;
import java.util.Map;

public class BrowserResponse implements Response {

    private final Map<String, List<String>> header;
    private final String                    body;
    private final Cookies                   cookies;
    private final int                       responseCode;
    private final Connect                   connect;

    BrowserResponse(Connect connect, Map<String, List<String>> header, String body, Cookies cookies, int responseCode) {
        this.connect      = connect;
        this.body         = body;
        this.header       = header;
        this.cookies      = cookies;
        this.responseCode = responseCode;
    }

    @Override
    public String getBody() {
        return body;
    }

    @Override
    public int getResponseCode() {
        return responseCode;
    }

    @Override
    public Connect getConnect() {
        return this.connect;
    }

    @Override
    public Map<String, List<String>> getHeader() {
        return header;
    }

    @Override
    public String getHeader(String name) {
        return header.get(name).get(header.size() - 1);
    }

    @Override
    public Cookies getCookies() {
        return cookies;
    }

    @Override
    public String getCookieVal(String name) {
        return cookies.get(name);
    }

    @Override
    public String toString() {
        return getBodyPrettyJSON();
    }

}
