package cn.omisheep.autt.util;

import cn.omisheep.autt.core.Cookies;
import cn.omisheep.commons.util.web.JSONUtils;
import com.fasterxml.jackson.core.type.TypeReference;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class SerializeUtil {

    public static String serialize(Object obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            String string = byteArrayOutputStream.toString(StandardCharsets.ISO_8859_1.displayName());
            objectOutputStream.close();
            byteArrayOutputStream.close();
            return string;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

    }

    public static Object serializeToObject(String str) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes(StandardCharsets.ISO_8859_1));
            ObjectInputStream    objectInputStream    = new ObjectInputStream(byteArrayInputStream);
            Object               object               = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
            return object;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serializeByJson(Object obj) {
        return JSONUtils.toJSONString(obj);
    }

    public static Object serializeToObjectByJson(String str) {
        return JSONUtils.parseJSON(str, new TypeReference<Map<String, Map<String, Cookies>>>() {});
    }

}