package cn.omisheep.autt;

import cn.omisheep.autt.core.BodyBuilder;
import cn.omisheep.autt.core.ContentType;

import java.util.function.Function;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @since 1.1.0
 */
public interface PostRequest extends Request {

    default PostRequest body(Object o, ContentType contentType) {
        return body(o).contentType(contentType);
    }

    PostRequest body(Object o);

    PostRequest contentType(ContentType contentType);

    default PostRequest jsonBody(Object o) {
        return body(o, ContentType.JSON);
    }

    default PostRequest formBody(Object o) {
        return body(o, ContentType.X_WWW_FORM_URLENCODED);
    }

    default PostRequest bodyBuilder(Function<BodyBuilder, BodyBuilder> body) {
        return body(body.apply(new BodyBuilder()).getBody());
    }

    default PostRequest bodyBuilderByJSON(Function<BodyBuilder, BodyBuilder> body) {
        return bodyBuilder(body).contentType(ContentType.JSON);
    }

    default PostRequest bodyBuilderByFORM(Function<BodyBuilder, BodyBuilder> body) {
        return bodyBuilder(body).contentType(ContentType.X_WWW_FORM_URLENCODED);
    }

    default PostRequest bodyBuilder(ContentType type, Function<BodyBuilder, BodyBuilder> body) {
        return bodyBuilder(body).contentType(type);
    }

}
