package cn.omisheep.autt.util;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @since 1.1.0
 */
public final class URLParser {

    public static URLInfo parse(String url) {
        URLInfo urlInfo = new URLInfo();
        int     i1      = url.indexOf(":");
        int     i2      = url.indexOf("/", 9);
        if (i2 == -1) {
            i2 = url.length();
            urlInfo.setPath(url.substring(0, i2));
        } else {
            int i3 = url.indexOf("?");
            if (i3 != -1) {
                urlInfo.setUri(url.substring(i2, i3)).setParam(url.substring(i3 + 1)).setPath(url.substring(0, i3));
            } else {
                urlInfo.setUri(url.substring(i2)).setPath(url);
            }
        }
        urlInfo.setProtocol(url.substring(0, i1)).setDomain(url.substring(i1 + 3, i2));
        return urlInfo;
    }

    @Data
    @Accessors(chain = true)
    public static class URLInfo {
        private String              protocol;
        private String              domain;
        private String              uri;
        private String              path;
        private Map<String, String> param = new HashMap<>();

        public URLInfo setParam(String param) {
            this.param.putAll(ConvertUtil.stringToMap(param));
            return this;
        }
    }

}
