package cn.omisheep.autt.util;

import java.io.*;
import java.nio.charset.StandardCharsets;

public final class SerializeUtil {

    public static String serialize(Object obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            String string = byteArrayOutputStream.toString(StandardCharsets.ISO_8859_1.displayName());
            objectOutputStream.close();
            byteArrayOutputStream.close();
            return string;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

    }

    public static Object serializeToObject(String str) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes(StandardCharsets.ISO_8859_1));
            ObjectInputStream    objectInputStream    = new ObjectInputStream(byteArrayInputStream);
            Object               object               = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
            return object;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serializeByJson(Object obj) {
        return JSONUtil.toJSONString(obj);
    }

    public static Object serializeToObjectByJson(String str) {
        return JSONUtil.readCookie(str);
    }

}