package cn.omisheep.autt.util;

import cn.omisheep.autt.core.Cookies;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.util.Map;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @since 1.0.4
 */
public final class JSONUtil {

    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JSONUtil() {
    }

    public static String toJSONString(Object o) {
        try {
            return OBJECT_MAPPER.writeValueAsString(o);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static <T> T parseJSON(String json, Class<T> cls) {
        try {
            return OBJECT_MAPPER.readValue(json, cls);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parseJSON(String json, TypeReference<T> tTypeReference) {
        try {
            System.out.println(json);
            return OBJECT_MAPPER.readValue(json, tTypeReference);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toPrettyJSON(String json) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(parseJSON(json, Map.class));
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Map<String, Map<String, Cookies>> readCookie(String json) {
        try {
            return OBJECT_MAPPER.readValue(json, new TypeReference<Map<String, Map<String, Cookies>>>() {});
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

}
