package cn.omisheep.autt;

import cn.omisheep.autt.core.Cookies;
import cn.omisheep.autt.util.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.List;
import java.util.Map;

public interface Response {

    String getBody();

    int getResponseCode();

    Connect getConnect();

    default String getBodyPrettyJSON() {
        return JSONUtil.toPrettyJSON(getBody());
    }

    default <T> T getBodyJSONObject(Class<T> cls) {
        return JSONUtil.parseJSON(getBody(), cls);
    }

    default <T> T getBodyJSONObject(TypeReference<T> typeReference) {
        return JSONUtil.parseJSON(getBody(), typeReference);
    }

    default Map<String, Object> getBodyJSONObject() {
        return JSONUtil.parseJSON(getBody(), new TypeReference<Map<String, Object>>() {});
    }

    default Document getBodyDocument() {
        return Jsoup.parse(getBody());
    }

    Map<String, List<String>> getHeader();

    String getHeader(String name);

    Cookies getCookies();

    String getCookieVal(String name);

}
