package cn.omisheep.autt;

import cn.omisheep.autt.core.ContentType;
import cn.omisheep.autt.core.browser.BrowserConnect;

/**
 * qq:1269670415  email:xinchenzhou666@gmail.com
 *
 * @author zhou xin chen
 */
public final class Autt {

    private static String ctx = "";

    private Autt() {
    }

    public static String getContext() {
        if (ctx == null) return "";
        if (ctx.startsWith("http")) return ctx;
        return "";
    }

    public static void setContext(String context) {
        ctx = context;
    }

    public static Connect connect() {
        return new BrowserConnect().setContext(ctx);
    }

    public static Connect connect(String saveCookie) {
        return new BrowserConnect().initCookie(saveCookie).setContext(ctx);
    }

    public static GetRequest get(String url) {
        return new BrowserConnect().setContext(ctx).get(url);
    }

    public static GetRequest get(String url, Object param) {
        return new BrowserConnect().setContext(ctx).get(url, param);
    }

    public static PostRequest post(String url, Object body, ContentType contentType) {
        return new BrowserConnect().setContext(ctx).post(url).body(body, contentType);
    }

    public static PostRequest post(String url, Object body) {
        return new BrowserConnect().setContext(ctx).post(url).body(body);
    }

    public static PostRequest post(String url) {
        return new BrowserConnect().setContext(ctx).post(url);
    }

    public static Response getAndSend(String url) {
        return get(ctx + url).send();
    }

    public static Response getAndSend(String url, Object param) {
        return get(ctx + url, param).send();
    }

    public static Response postAndSend(String url, Object body, ContentType contentType) {
        return post(ctx + url, body, contentType).send();
    }

    public static Response postByJSONAndSend(String url, Object body) {
        return postAndSend(url, body, ContentType.JSON);
    }

}
