/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.util;

import cn.omisheep.commons.util.web.JSONUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportUtils {
    private static final Logger log = LoggerFactory.getLogger(SupportUtils.class);
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private SupportUtils() {
        throw new UnsupportedOperationException();
    }

    public static String read(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return SupportUtils.read(reader);
    }

    public static String readFromResource(String resource) {
        InputStream in;
        block4: {
            String string;
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    in = SupportUtils.class.getResourceAsStream(resource);
                }
                if (in != null) break block4;
                string = null;
            }
            catch (Throwable throwable) {
                SupportUtils.close(in);
                throw throwable;
            }
            SupportUtils.close(in);
            return string;
        }
        String string = SupportUtils.read(in);
        SupportUtils.close(in);
        return string;
    }

    public static String read(Reader reader) {
        try {
            int n;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block3: {
            byte[] byArray;
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in != null) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                SupportUtils.close(in);
                throw throwable;
            }
            SupportUtils.close(in);
            return byArray;
        }
        byte[] byArray = SupportUtils.readByteArray(in);
        SupportUtils.close(in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SupportUtils.copy(input, output);
        return output.toByteArray();
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        int EOF = -1;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            log.debug("close error", (Throwable)e);
        }
    }

    public static void toJSON(HttpServletResponse response, Object o) {
        try {
            response.setContentType("application/json;charset=utf-8");
            if (o instanceof String) {
                response.getWriter().println(o);
            } else {
                response.getWriter().println(JSONUtils.toJSONString((Object)o));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void forbid(HttpServletResponse response) {
        response.setStatus(404);
    }
}

