/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.http.handler;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.support.entity.User;
import cn.omisheep.authz.support.http.annotation.Header;
import cn.omisheep.authz.support.http.annotation.JSON;
import cn.omisheep.authz.support.http.annotation.Param;
import cn.omisheep.authz.support.util.SupportUtils;
import cn.omisheep.commons.util.web.JSONUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.core.annotation.AnnotationUtils;

public class ApiHandler {
    private static final HashMap<String, ApiInfo> api = new HashMap();

    public void process(HttpServletRequest request, HttpServletResponse response, String path, boolean auth, User user) {
        HttpMeta httpMeta = (HttpMeta)request.getAttribute("AU_HTTP_META");
        String apiPath = path.substring("/v1".length());
        ApiInfo apiInfo = api.get(apiPath);
        if (apiInfo == null || !apiInfo.getMethod().equals(httpMeta.getMethod())) {
            SupportUtils.forbid(response);
            return;
        }
        if (apiInfo.requireLogin && !auth) {
            SupportUtils.forbid(response);
            return;
        }
        Method invoke = apiInfo.getInvoke();
        Parameter[] parameters = invoke.getParameters();
        try {
            if (parameters == null || parameters.length == 0) {
                SupportUtils.toJSON(response, invoke.invoke(AuthzContext.getBean(invoke.getDeclaringClass()), new Object[0]));
                return;
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Parameter parameter : parameters) {
                Class<?> type = parameter.getType();
                if (AnnotationUtils.getAnnotation((AnnotatedElement)parameter, JSON.class) != null) {
                    objects.add(JSONUtils.parseJSON((String)httpMeta.getBody(), type));
                    continue;
                }
                Param param = (Param)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, Param.class);
                if (param != null) {
                    try {
                        String requestParameter = request.getParameter(!Objects.equals(param.name(), "") ? param.name() : parameter.getName());
                        objects.add(type.getConstructor(String.class).newInstance(requestParameter));
                    }
                    catch (Exception e) {
                        objects.add(null);
                    }
                    continue;
                }
                Header header = (Header)AnnotationUtils.getAnnotation((AnnotatedElement)parameter, Header.class);
                if (header != null) {
                    try {
                        String val = request.getHeader(!Objects.equals(header.name(), "") ? header.name() : parameter.getName());
                        objects.add(type.getConstructor(String.class).newInstance(val));
                    }
                    catch (Exception e) {
                        objects.add(null);
                    }
                    continue;
                }
                if (HttpServletRequest.class.equals(type)) {
                    objects.add(request);
                    continue;
                }
                if (HttpServletResponse.class.equals(type)) {
                    objects.add(response);
                    continue;
                }
                if (HttpSession.class.equals(type)) {
                    objects.add(request.getSession());
                    continue;
                }
                if (HttpMeta.class.equals(type)) {
                    objects.add(httpMeta);
                    continue;
                }
                if (User.class.equals(type)) {
                    objects.add(user);
                    continue;
                }
                objects.add(AuthzContext.getBean(type));
            }
            SupportUtils.toJSON(response, invoke.invoke(AuthzContext.getBean(invoke.getDeclaringClass()), objects.toArray()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashMap<String, ApiInfo> getApi() {
        return api;
    }

    public static class ApiInfo {
        @JsonProperty(index=2)
        private String method;
        @JsonProperty(index=1)
        private boolean requireLogin;
        @JsonIgnore
        private Method invoke;
        @JsonProperty(index=3)
        private String desc;

        public String getMethod() {
            return this.method;
        }

        public boolean isRequireLogin() {
            return this.requireLogin;
        }

        public Method getInvoke() {
            return this.invoke;
        }

        public String getDesc() {
            return this.desc;
        }

        @JsonProperty(index=2)
        public ApiInfo setMethod(String method) {
            this.method = method;
            return this;
        }

        @JsonProperty(index=1)
        public ApiInfo setRequireLogin(boolean requireLogin) {
            this.requireLogin = requireLogin;
            return this;
        }

        @JsonIgnore
        public ApiInfo setInvoke(Method invoke) {
            this.invoke = invoke;
            return this;
        }

        @JsonProperty(index=3)
        public ApiInfo setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiInfo)) {
                return false;
            }
            ApiInfo other = (ApiInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequireLogin() != other.isRequireLogin()) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Method this$invoke = this.getInvoke();
            Method other$invoke = other.getInvoke();
            if (this$invoke == null ? other$invoke != null : !((Object)this$invoke).equals(other$invoke)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequireLogin() ? 79 : 97);
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Method $invoke = this.getInvoke();
            result = result * 59 + ($invoke == null ? 43 : ((Object)$invoke).hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            return result;
        }

        public String toString() {
            return "ApiHandler.ApiInfo(method=" + this.getMethod() + ", requireLogin=" + this.isRequireLogin() + ", invoke=" + this.getInvoke() + ", desc=" + this.getDesc() + ")";
        }
    }
}

