/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.http.api;

import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.support.entity.User;
import cn.omisheep.authz.support.http.ApiSupport;
import cn.omisheep.authz.support.http.SupportServlet;
import cn.omisheep.authz.support.http.annotation.Get;
import cn.omisheep.authz.support.http.annotation.JSON;
import cn.omisheep.authz.support.http.annotation.Mapping;
import cn.omisheep.authz.support.http.annotation.Post;
import cn.omisheep.web.entity.Result;

@Mapping(value="/user", requireLogin=false)
public class UserApiSupport
implements ApiSupport {
    private final Cache cache;

    public UserApiSupport(Cache cache) {
        this.cache = cache;
    }

    @Post(value="/login", requireLogin=false, desc="\u767b\u5f55")
    public Result login(@JSON User user, HttpMeta httpMeta) {
        if (user != null) {
            User loginUser = SupportServlet.login(user.getUsername(), user.getPassword(), httpMeta.getIp(), this.cache);
            if (loginUser == null) {
                return Result.FAIL.data();
            }
            return Result.SUCCESS.data("username", (Object)user.getUsername()).data("uuid", (Object)loginUser.getUuid());
        }
        return Result.FAIL.data();
    }

    @Get(value="/check-status", requireLogin=false, desc="\u72b6\u6001\u68c0\u67e5")
    public Result checkLogin(HttpMeta httpMeta) {
        if (!SupportServlet.requireLogin()) {
            return Result.SUCCESS.data();
        }
        User user = SupportServlet.connectPkg(httpMeta.getRequest(), httpMeta.getIp(), this.cache);
        if (user != null) {
            return Result.SUCCESS.data();
        }
        return Result.FAIL.data();
    }

    @Get(value="/logout", desc="\u9000\u51fa\u767b\u5f55")
    public Result logout(User user) {
        if (!SupportServlet.requireLogin()) {
            return Result.SUCCESS.data();
        }
        this.cache.del(Constants.DASHBOARD_KEY_PREFIX.get() + user.getUuid());
        return Result.SUCCESS.data();
    }

    @Get(value="/expiration-time", requireLogin=false, desc="\u5931\u6548\u65f6\u95f4")
    public Result expirationTime() {
        return Result.SUCCESS.data((Object)SupportServlet.getUnresponsiveExpirationTime());
    }
}

