/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.http.api;

import cn.omisheep.authz.core.AuthzManager;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.AuthzVersion;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.support.entity.User;
import cn.omisheep.authz.support.http.ApiSupport;
import cn.omisheep.authz.support.http.annotation.Get;
import cn.omisheep.authz.support.http.annotation.JSON;
import cn.omisheep.authz.support.http.annotation.Param;
import cn.omisheep.authz.support.http.annotation.Post;
import cn.omisheep.web.entity.Result;

public class StandardApiSupport
implements ApiSupport {
    public StandardApiSupport(AuthzProperties properties) {
    }

    @Get(value="/echo", desc="echo")
    public Result echo(@Param String msg) {
        return Result.SUCCESS.data((Object)msg);
    }

    @Post(value="/operate", desc="\u6743\u9650\u64cd\u4f5c\u901a\u7528\u63a5\u53e3")
    public Result operate(@JSON AuthzModifier modifier, User user) {
        if (user.getPermissions() == null || user.getPermissions().isEmpty()) {
            return Result.FAIL.data();
        }
        if (modifier == null) {
            return Result.FAIL.data();
        }
        try {
            AuthzProperties.DashboardConfig.DashboardPermission dashboardPermission = AuthzProperties.DashboardConfig.DashboardPermission.valueOf(modifier.getTarget().name());
            if (user.getPermissions().contains((Object)AuthzProperties.DashboardConfig.DashboardPermission.ALL) || user.getPermissions().contains((Object)dashboardPermission)) {
                return AuthzManager.operate(modifier);
            }
        }
        catch (Exception e) {
            Result.FAIL.data();
        }
        return Result.FAIL.data();
    }

    @Get(value="/version", desc="\u7248\u672c\u53f7")
    public String version() {
        return AuthzVersion.getVersion();
    }
}

