/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.http.api;

import cn.omisheep.authz.AuHelper;
import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.auth.ipf.Blacklist;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.support.http.ApiSupport;
import cn.omisheep.authz.support.http.annotation.Get;
import cn.omisheep.authz.support.http.annotation.JSON;
import cn.omisheep.authz.support.http.annotation.Mapping;
import cn.omisheep.authz.support.http.annotation.Param;
import cn.omisheep.authz.support.http.annotation.Post;
import cn.omisheep.authz.support.util.IPAddress;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.web.entity.Result;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@Mapping(value="/device", requireLogin=false)
public class DeviceApiSupport
implements ApiSupport {
    @Get(value="/all", desc="\u83b7\u5f97\u6240\u6709\u8bbe\u5907")
    public Result version() {
        return Result.SUCCESS.data(AuHelper.getAllUserDevices());
    }

    @Get(value="/get-all-userid", desc="\u83b7\u5f97\u5f53\u524d\u6709\u6548\u7528\u6237id\u5217\u8868")
    public Result getAllUserId() {
        try {
            return Result.SUCCESS.data(AuHelper.getAllUserId());
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    @Get(value="/active-users-count", desc="\u5f53\u524d\u5728\u7ebf\u7528\u6237\u6570\u91cf")
    public Result activeUsersCount(@Param String time) {
        return Result.SUCCESS.data((Object)AuHelper.getNumberOfActiveUser(time));
    }

    @Get(value="/active-users", desc="\u5f53\u524d\u5728\u7ebf\u7528\u6237\u7684\u8be6\u7ec6\u8bbe\u5907\u4fe1\u606f")
    public Result activeUsers(@Param String time) {
        return Result.SUCCESS.data(AuHelper.getActiveDevices(time));
    }

    @Get(value="/check-is-login", desc="\u5f53\u524d\u5728\u7ebf\u7528\u6237\u7684\u8be6\u7ec6\u8bbe\u5907\u4fe1\u606f")
    public Result checkLogin(@Param String userId, @Param String id) {
        try {
            return Result.SUCCESS.data((Object)AuHelper.isLoginById(AuthzContext.createUserId(userId), id));
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    @Get(value="/logout", desc="\u5f53\u524d\u5728\u7ebf\u7528\u6237\u7684\u8be6\u7ec6\u8bbe\u5907\u4fe1\u606f")
    public Result logout(@Param String userId, @Param String id) {
        try {
            AuHelper.logoutById(AuthzContext.createUserId(userId), id);
            return Result.SUCCESS.data();
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    @Post(value="/get-deny-info", desc="\u83b7\u5f97\u5c01\u7981\u4fe1\u606f")
    public Result getDenyInfo(@JSON AuthzModifier.BlacklistInfo info) {
        try {
            return Result.SUCCESS.data((Object)new DenyInfo(AuthzContext.createUserId(info.getUserId()), info));
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    @Get(value="/get-all-deny-info", desc="\u83b7\u5f97\u5c01\u7981\u4fe1\u606f")
    public Result getAllDenyInfo() {
        try {
            return Result.SUCCESS.data(Blacklist.readAll());
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    @Post(value="/deny", desc="\u5c01\u7981")
    public Result denyInfo(@JSON AuthzModifier.BlacklistInfo info) {
        try {
            Object _userId = AuthzContext.createUserId(info.getUserId());
            Date endTime = TimeUtils.formatParse((String)info.getDate());
            switch (info.getType()) {
                case USER: {
                    AuHelper.denyUser(_userId, endTime);
                    break;
                }
                case DEVICE: {
                    AuHelper.denyDevice(_userId, info.getDeviceType(), info.getDeviceId(), endTime);
                    break;
                }
                case IP: {
                    AuHelper.denyIP(info.getIp(), endTime);
                    break;
                }
                case IP_RANGE: {
                    AuHelper.denyIPRange(info.getIp(), endTime);
                    break;
                }
                default: {
                    return Result.FAIL.data();
                }
            }
            return Result.SUCCESS.data((Object)new DenyInfo(_userId, info));
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    @Post(value="/deny-remove", desc="\u79fb\u9664\u5c01\u7981")
    public Result removeDenyInfo(@JSON AuthzModifier.BlacklistInfo info) {
        try {
            Object _userId = AuthzContext.createUserId(info.getUserId());
            switch (info.getType()) {
                case USER: {
                    AuHelper.removeDenyUser(_userId);
                    break;
                }
                case DEVICE: {
                    AuHelper.removeDenyDevice(_userId, info.getDeviceType(), info.getDeviceId());
                    break;
                }
                case IP: {
                    AuHelper.removeDenyIP(info.getIp());
                    break;
                }
                case IP_RANGE: {
                    AuHelper.removeDenyIPRange(info.getIp());
                    break;
                }
                default: {
                    return Result.FAIL.data();
                }
            }
            return Result.SUCCESS.data((Object)new DenyInfo(_userId, info));
        }
        catch (Exception e) {
            return Result.FAIL.data();
        }
    }

    public static class DenyInfo {
        private Blacklist.User userId;
        private Blacklist.User device;
        private Blacklist.IP ip;
        private Set<Blacklist.IPRangeDeny> iprange;

        public DenyInfo(Object _userId, AuthzModifier.BlacklistInfo info) {
            this.userId = AuHelper.getDenyUserInfo(_userId);
            this.device = AuHelper.getDenyDeviceInfo(info.getUserId(), info.getDeviceType(), info.getDeviceId());
            this.ip = AuHelper.getDenyIPInfo(info.getIp());
            if (info.getIp() != null) {
                IPAddress ipAddress = new IPAddress(info.getIp());
                this.iprange = AuHelper.getAllDenyIPRangeInfo().stream().filter(v -> v.getIpRange().isIPAddressInRange(ipAddress)).collect(Collectors.toSet());
            } else {
                this.iprange = new HashSet<Blacklist.IPRangeDeny>(0);
            }
        }

        public Blacklist.User getUserId() {
            return this.userId;
        }

        public Blacklist.User getDevice() {
            return this.device;
        }

        public Blacklist.IP getIp() {
            return this.ip;
        }

        public Set<Blacklist.IPRangeDeny> getIprange() {
            return this.iprange;
        }

        public void setUserId(Blacklist.User userId) {
            this.userId = userId;
        }

        public void setDevice(Blacklist.User device) {
            this.device = device;
        }

        public void setIp(Blacklist.IP ip) {
            this.ip = ip;
        }

        public void setIprange(Set<Blacklist.IPRangeDeny> iprange) {
            this.iprange = iprange;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DenyInfo)) {
                return false;
            }
            DenyInfo other = (DenyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Blacklist.User this$userId = this.getUserId();
            Blacklist.User other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            Blacklist.User this$device = this.getDevice();
            Blacklist.User other$device = other.getDevice();
            if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
                return false;
            }
            Blacklist.IP this$ip = this.getIp();
            Blacklist.IP other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !((Object)this$ip).equals(other$ip)) {
                return false;
            }
            Set<Blacklist.IPRangeDeny> this$iprange = this.getIprange();
            Set<Blacklist.IPRangeDeny> other$iprange = other.getIprange();
            return !(this$iprange == null ? other$iprange != null : !((Object)this$iprange).equals(other$iprange));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DenyInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Blacklist.User $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            Blacklist.User $device = this.getDevice();
            result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
            Blacklist.IP $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : ((Object)$ip).hashCode());
            Set<Blacklist.IPRangeDeny> $iprange = this.getIprange();
            result = result * 59 + ($iprange == null ? 43 : ((Object)$iprange).hashCode());
            return result;
        }

        public String toString() {
            return "DeviceApiSupport.DenyInfo(userId=" + this.getUserId() + ", device=" + this.getDevice() + ", ip=" + this.getIp() + ", iprange=" + this.getIprange() + ")";
        }
    }
}

