/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.http;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.util.FormatUtils;
import cn.omisheep.authz.core.util.IPUtils;
import cn.omisheep.authz.support.entity.User;
import cn.omisheep.authz.support.http.handler.ApiHandler;
import cn.omisheep.authz.support.util.IPAddress;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.authz.support.util.IPRangeMeta;
import cn.omisheep.authz.support.util.SupportUtils;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.UUIDBits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SupportServlet.class);
    private static final String resourceRootPath = "support/http/dist";
    private static final String resourcePath = "support/http/dist/authz-dashboard-static";
    private static final String nopermit = "support/http/nopermit.html";
    private final List<IPRange> allowList = new ArrayList<IPRange>();
    private final List<IPRange> denyList = new ArrayList<IPRange>();
    private final ApiHandler apiHandler = new ApiHandler();
    private final boolean requireLogin;
    private final Cache cache;
    private static final String UUID = "uuid";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final Set<User> users = new HashSet<User>();
    private static long unresponsiveExpirationTime;

    public static boolean requireLogin() {
        return !users.isEmpty();
    }

    public SupportServlet(AuthzProperties.DashboardConfig dashboardConfig, Cache cache) {
        this.cache = cache;
        this.requireLogin = !StringUtils.isEmpty((String)dashboardConfig.getUsername()) && !StringUtils.isEmpty((String)dashboardConfig.getPassword()) || !dashboardConfig.getUsers().isEmpty();
        try {
            this.allowList.addAll(IPRangeMeta.parse(dashboardConfig.getAllow()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.denyList.addAll(IPRangeMeta.parse(dashboardConfig.getDeny()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        users.addAll(dashboardConfig.getUsers().stream().map(User::new).collect(Collectors.toList()));
        String username = dashboardConfig.getUsername();
        String password = dashboardConfig.getPassword();
        AuthzProperties.DashboardConfig.DashboardPermission[] permissions = dashboardConfig.getPermissions();
        if (!StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password)) {
            users.add(new User(username, password, null, permissions));
        }
        unresponsiveExpirationTime = TimeUtils.parseTimeValue((String)dashboardConfig.getUnresponsiveExpirationTime());
    }

    public static User login(String username, String password, String ip, Cache cache) {
        if (users.isEmpty()) {
            return null;
        }
        if (username == null || password == null) {
            return null;
        }
        try {
            Optional<User> any = users.stream().filter(u -> StringUtils.equals((String)u.getUsername(), (String)username) && StringUtils.equals((String)u.getPassword(), (String)password)).findAny();
            if (any.isPresent()) {
                User user = any.get().clone().setIp(HttpMeta.currentHttpMeta().getIp()).setUuid(UUIDBits.getUUIDBits((int)16));
                cache.set(Constants.DASHBOARD_KEY_PREFIX.get() + user.getUuid(), user, unresponsiveExpirationTime);
                return user;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static User auth(HttpServletRequest request, String ip, Cache cache) {
        User user = SupportServlet.getUser(request, ip, cache);
        if (user == null) {
            return SupportServlet.login(request.getParameter(USERNAME), request.getParameter(PASSWORD), ip, cache);
        }
        return user;
    }

    public static User getUser(HttpServletRequest request, String ip, Cache cache) {
        String uuid;
        if (ip == null) {
            return null;
        }
        String uuid1 = request.getHeader(UUID);
        String string = uuid = uuid1 != null ? uuid1 : request.getParameter(UUID);
        if (uuid == null) {
            return null;
        }
        User user = cache.get(Constants.DASHBOARD_KEY_PREFIX.get() + uuid, User.class);
        if (user == null) {
            return null;
        }
        if (StringUtils.equals((String)ip, (String)user.getIp())) {
            return user;
        }
        cache.del(Constants.DASHBOARD_KEY_PREFIX.get() + uuid);
        return null;
    }

    public static User connectPkg(HttpServletRequest request, String ip, Cache cache) {
        User user = SupportServlet.getUser(request, ip, cache);
        if (user == null) {
            return null;
        }
        cache.expire(Constants.DASHBOARD_KEY_PREFIX.get() + user.getUuid(), unresponsiveExpirationTime);
        return user;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = Objects.equals(servletPath, "/authz.html") || Objects.equals(servletPath, "/authz-dashboard-favicon.ico") ? servletPath : requestURI.substring(contextPath.length() + servletPath.length());
        response.setCharacterEncoding("utf-8");
        String ip = IPUtils.getIp(request);
        if (!this.checkIp(ip, response)) {
            return;
        }
        if (this.gotoIndex(contextPath, path, request, response)) {
            return;
        }
        if ("/authz-api".equals(servletPath) && path.startsWith("/v1")) {
            User user = SupportServlet.auth(request, ip, this.cache);
            this.apiHandler.process(request, response, path, !this.requireLogin || user != null, user);
            return;
        }
        this.returnResourceFile(path, uri, request, response);
    }

    private boolean checkIp(String ip, HttpServletResponse response) throws IOException {
        try {
            if (!this.isPermittedRequest(ip)) {
                this.nopermit(response);
                return false;
            }
        }
        catch (Exception e) {
            this.nopermit(response);
            return false;
        }
        return true;
    }

    private boolean gotoIndex(String contextPath, String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("".equals(path)) {
            if (contextPath.equals("") || contextPath.equals("/")) {
                this.sendRedirect(request, response, "/authz.html");
            } else {
                this.sendRedirect(request, response, "/authz.html");
            }
            return true;
        }
        if ("/".equals(path)) {
            this.sendRedirect(request, response, "authz.html");
            return true;
        }
        return false;
    }

    private void nopermit(HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        String text = SupportUtils.readFromResource(nopermit);
        if (text == null) {
            response.getWriter().write("");
            response.setStatus(404);
        } else {
            response.getWriter().write(text);
        }
    }

    private void returnResourceFile(String fileName, String uri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filePath = Objects.equals(fileName, "/authz.html") ? "support/http/dist/index.html" : (Objects.equals(fileName, "/authz-dashboard-favicon.ico") ? "support/http/dist/authz-dashboard-favicon.ico" : resourcePath + fileName);
        if (filePath.endsWith(".html")) {
            response.setContentType("text/html; charset=utf-8");
        }
        if (FormatUtils.isIgnoreSuffix(fileName, Constants.SUFFIX)) {
            byte[] bytes = SupportUtils.readByteArrayFromResource(filePath);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = SupportUtils.readFromResource(filePath);
        if (text == null) {
            this.sendRedirect(request, response, uri + "/authz.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        } else if (fileName.endsWith(".svg")) {
            response.setContentType("image/svg+xml");
        }
        response.getWriter().write(text);
    }

    private boolean isPermittedRequest(String remoteAddress) {
        boolean ipV6;
        boolean bl = ipV6 = remoteAddress != null && remoteAddress.indexOf(58) != -1;
        if (ipV6) {
            return "0:0:0:0:0:0:0:1".equals(remoteAddress) || this.denyList.size() == 0 && this.allowList.size() == 0;
        }
        IPAddress ipAddress = new IPAddress(remoteAddress);
        for (IPRange range : this.denyList) {
            if (!range.isIPAddressInRange(ipAddress)) continue;
            return false;
        }
        if (this.allowList.size() > 0) {
            for (IPRange range : this.allowList) {
                if (!range.isIPAddressInRange(ipAddress)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void sendRedirect(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        Map parameterMap = request.getParameterMap();
        if (parameterMap.isEmpty()) {
            response.sendRedirect(path);
            return;
        }
        StringBuilder builder = new StringBuilder(path).append("?");
        Iterator iterator = parameterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            builder.append((String)next.getKey()).append("=").append(((String[])next.getValue())[0]);
            if (!iterator.hasNext()) continue;
            builder.append("&");
        }
        response.sendRedirect(builder.toString());
    }

    public static long getUnresponsiveExpirationTime() {
        return unresponsiveExpirationTime;
    }
}

