/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.entity;

import cn.omisheep.authz.core.AuthzProperties;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class User
implements Cloneable {
    private String username;
    private String password;
    private String ip;
    private List<AuthzProperties.DashboardConfig.DashboardPermission> permissions;
    private String uuid;

    public User(AuthzProperties.DashboardConfig.User user) {
        this.username = user.getUsername();
        this.password = user.getPassword();
        this.ip = user.getIp();
        this.permissions = Arrays.asList(user.getPermissions());
        this.uuid = null;
    }

    public User(String username, String password, String ip, AuthzProperties.DashboardConfig.DashboardPermission[] permissions) {
        this.username = username;
        this.password = password;
        this.ip = ip;
        this.permissions = Arrays.asList(permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equal((Object)this.getUsername(), (Object)user.getUsername());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUsername()});
    }

    public User clone() {
        try {
            User clone = (User)super.clone();
            clone.permissions = new ArrayList<AuthzProperties.DashboardConfig.DashboardPermission>(this.permissions);
            clone.username = this.username;
            clone.password = this.password;
            clone.ip = this.ip;
            clone.uuid = this.uuid;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIp() {
        return this.ip;
    }

    public List<AuthzProperties.DashboardConfig.DashboardPermission> getPermissions() {
        return this.permissions;
    }

    public String getUuid() {
        return this.uuid;
    }

    public User setUsername(String username) {
        this.username = username;
        return this;
    }

    public User setPassword(String password) {
        this.password = password;
        return this;
    }

    public User setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public User setPermissions(List<AuthzProperties.DashboardConfig.DashboardPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public User setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String toString() {
        return "User(username=" + this.getUsername() + ", password=" + this.getPassword() + ", ip=" + this.getIp() + ", permissions=" + this.getPermissions() + ", uuid=" + this.getUuid() + ")";
    }

    public User() {
    }
}

