/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.util.ArgsParser;
import cn.omisheep.authz.core.util.LogUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.lang.NonNull;

public class ValueMatcher {
    private static final Map<Object, Object> typesMapper = ImmutableMap.builder().put((Object)String.class.getTypeName(), String.class).put((Object)Integer.class.getTypeName(), Integer.class).put((Object)Integer.TYPE.getTypeName(), Integer.class).put((Object)Long.class.getTypeName(), Long.class).put((Object)Long.TYPE.getTypeName(), Long.class).put((Object)Short.class.getTypeName(), Short.class).put((Object)Short.TYPE.getTypeName(), Short.class).put((Object)Double.class.getTypeName(), Double.class).put((Object)Double.TYPE.getTypeName(), Double.class).put((Object)Float.class.getTypeName(), Float.class).put((Object)Float.TYPE.getTypeName(), Float.class).put((Object)Character.class.getTypeName(), Character.class).put((Object)Character.TYPE.getTypeName(), Character.class).put((Object)Boolean.class.getTypeName(), Boolean.class).put((Object)Boolean.TYPE.getTypeName(), Boolean.class).build();
    private static final Map<Object, Object> valueTypesMapper = ImmutableMap.builder().put(String.class, (Object)ValueType.EQUALS).put(Character.class, (Object)ValueType.EQUALS).put(Character.TYPE, (Object)ValueType.EQUALS).put(Boolean.class, (Object)ValueType.EQUALS).put(Boolean.TYPE, (Object)ValueType.EQUALS).put(Integer.class, (Object)ValueType.RANGE).put(Integer.TYPE, (Object)ValueType.RANGE).put(Long.class, (Object)ValueType.RANGE).put(Long.TYPE, (Object)ValueType.RANGE).put(Short.class, (Object)ValueType.RANGE).put(Short.TYPE, (Object)ValueType.RANGE).put(Double.class, (Object)ValueType.RANGE).put(Double.TYPE, (Object)ValueType.RANGE).put(Float.class, (Object)ValueType.RANGE).put(Float.TYPE, (Object)ValueType.RANGE).build();

    private ValueMatcher() {
        throw new UnsupportedOperationException();
    }

    public static boolean match(Set<String> resources, String rawValue, String valueTypeName, ValueType valueType) {
        return resources.stream().anyMatch(resource -> ValueMatcher.match(resource, rawValue, valueTypeName, valueType));
    }

    private static boolean matchArg(Object obj, Object rawValue, String valueTypeName) {
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().anyMatch(o -> ObjectUtils.equals((Object)o, (Object)ValueMatcher.parse(rawValue.toString(), valueTypeName)));
        }
        return ObjectUtils.equals((Object)obj, (Object)ValueMatcher.parse(rawValue.toString(), valueTypeName));
    }

    public static boolean match(String resources, String rawValue, String valueTypeName, ValueType valueType) {
        if (resources == null) {
            return false;
        }
        if (resources.equals("*")) {
            return true;
        }
        try {
            if (valueType.equals((Object)ValueType.EQUALS)) {
                return ValueMatcher.matchArg(ArgsParser.parse(resources), rawValue, valueTypeName);
            }
            if (valueType.equals((Object)ValueType.RANGE)) {
                String[] split = resources.split("-");
                if (split.length > 2) {
                    return false;
                }
                if (split.length == 2) {
                    Object value = ValueMatcher.parse(rawValue, valueTypeName);
                    Object v1 = ArgsParser.parse(split[0], () -> ValueMatcher.parse(split[0], valueTypeName));
                    Object v2 = ArgsParser.parse(split[1], () -> ValueMatcher.parse(split[1], valueTypeName));
                    if (v1 == null || v2 == null || v1 instanceof Collection || v2 instanceof Collection || ValueMatcher.checkType(v1) != ValueType.RANGE || ValueMatcher.checkType(v2) != ValueType.RANGE) {
                        return false;
                    }
                    Comparable left = (Comparable)v1;
                    Comparable right = (Comparable)v2;
                    if (left.compareTo(value) <= 0 && right.compareTo(value) >= 0) {
                        return true;
                    }
                } else if (split.length == 1) {
                    return ValueMatcher.matchArg(ArgsParser.parse(split[0]), ValueMatcher.parse(rawValue, valueTypeName), valueTypeName);
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Object parse(String value, String valueTypeName) {
        Class clz = (Class)typesMapper.get(valueTypeName);
        if (clz != null) {
            return clz.getConstructor(String.class).newInstance(value);
        }
        return null;
    }

    public static Class<?> getType(String type) {
        Class clz = (Class)typesMapper.get(type);
        if (clz != null) {
            return clz;
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static ValueType checkTypeByName(String valueTypeName) {
        try {
            Object o = typesMapper.get(valueTypeName);
            if (o == null) {
                return ValueType.OTHER;
            }
            ValueType type = (ValueType)((Object)valueTypesMapper.get(o));
            if (type == null) {
                return ValueType.OTHER;
            }
            return type;
        }
        catch (Exception e) {
            LogUtils.error(e);
            return ValueType.OTHER;
        }
    }

    public static ValueType checkType(@NonNull Object obj) {
        return ValueMatcher.checkTypeByClass(obj.getClass());
    }

    public static ValueType checkTypeByClass(Class<?> type) {
        ValueType valueType = (ValueType)((Object)valueTypesMapper.get(type));
        if (valueType == null) {
            return ValueType.OTHER;
        }
        return valueType;
    }

    public static enum ValueType {
        RANGE,
        EQUALS,
        OTHER;


        @JsonValue
        public String getValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @JsonCreator
        public ValueType create(String name) {
            return ValueType.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public boolean isOther() {
            return this == OTHER;
        }

        public boolean notOther() {
            return this != OTHER;
        }
    }
}

