/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.Assert;
import cn.omisheep.commons.util.ClassUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static final RedisTemplate<String, Object> redisTemplate = AuthzContext.getBean("authzRedisTemplate", RedisTemplate.class);
    private static final int SCAN_COUNT;

    private RedisUtils() {
        throw new UnsupportedOperationException();
    }

    public static Set<String> keys(String pattern) {
        try {
            return redisTemplate.keys((Object)pattern);
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public static Set<String> scan(String pattern) {
        try {
            RedisConnectionFactory connectionFactory = redisTemplate.getConnectionFactory();
            if (connectionFactory == null) {
                return new HashSet<String>();
            }
            HashSet<String> keys = new HashSet<String>();
            RedisConnection connection = connectionFactory.getConnection();
            if (connection instanceof JedisClusterConnection || connection instanceof LettuceClusterConnection) {
                RedisClusterConnection clusterConnection = connectionFactory.getClusterConnection();
                for (RedisClusterNode next : clusterConnection.clusterGetNodes()) {
                    Cursor scan = clusterConnection.scan(next, ScanOptions.scanOptions().match(pattern).count((long)SCAN_COUNT).build());
                    while (scan.hasNext()) {
                        keys.add(new String((byte[])scan.next()));
                    }
                    scan.close();
                }
                return keys;
            }
            if (connection instanceof JedisConnection || connection instanceof LettuceConnection) {
                Cursor scan = connection.scan(ScanOptions.scanOptions().match(pattern).count((long)SCAN_COUNT).build());
                while (scan.hasNext()) {
                    keys.add(new String((byte[])scan.next()));
                }
                scan.close();
                return keys;
            }
        }
        catch (Exception connectionFactory) {
            // empty catch block
        }
        return new HashSet<String>();
    }

    public static boolean expire(String key, String timeVal) {
        return RedisUtils.expire(key, TimeUtils.parseTimeValue((String)timeVal));
    }

    public static boolean expire(String key, long ms) {
        try {
            if (ms > 0L) {
                redisTemplate.expire((Object)key, Duration.ofMillis(ms));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long ttl(String key) {
        try {
            Long expire = redisTemplate.getExpire((Object)key);
            return expire != null ? expire : -2L;
        }
        catch (Exception e) {
            return -2L;
        }
    }

    public static boolean hasKey(String key) {
        try {
            Boolean bool = redisTemplate.hasKey((Object)key);
            return bool != null && bool != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void publish(String channel, Message message) {
        try {
            LogUtils.debug("time: {} message: {}", TimeUtils.nowTime(), message);
            redisTemplate.convertAndSend(channel, (Object)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        RedisProperties properties = AuthzContext.getBean(RedisProperties.class);
        AuthzProperties authzProperties = AuthzContext.getBean(AuthzProperties.class);
        SCAN_COUNT = authzProperties.getCache().getRedisScanCount();
        Duration timeout = properties.getTimeout();
        try {
            Object execute = redisTemplate.execute(RedisConnectionCommands::ping);
            Assert.state((execute != null && execute.equals("PONG") ? 1 : 0) != 0, (String)"\u8bf7\u914d\u7f6eredis\u5e76\u786e\u4fdd\u5176\u80fd\u591f\u6b63\u5e38\u8fde\u63a5");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (timeout == null || timeout.isZero()) {
            properties.setTimeout(Duration.ofSeconds(10L));
        }
    }

    public static class Obj {
        public static void set(String key, Object value) {
            try {
                redisTemplate.opsForValue().set((Object)key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void set(String key, Object value, long ms) {
            try {
                redisTemplate.opsForValue().set((Object)key, value, ms, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void set(Map<String, ?> map) {
            try {
                redisTemplate.opsForValue().multiSet(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static Object get(String key) {
            try {
                return redisTemplate.opsForValue().get((Object)key);
            }
            catch (Exception e) {
                return null;
            }
        }

        public static <E> E get(String key, Class<E> requiredType) {
            try {
                return (E)ClassUtils.castValue((Object)redisTemplate.opsForValue().get((Object)key), requiredType);
            }
            catch (Exception e) {
                return null;
            }
        }

        public static List get(Collection<String> key) {
            try {
                List objects = redisTemplate.opsForValue().multiGet(key);
                if (objects == null) {
                    return new ArrayList();
                }
                return objects;
            }
            catch (Exception e) {
                return new ArrayList();
            }
        }

        public static Map<String, Object> getToMap(Collection<String> key) {
            try {
                List objects = redisTemplate.opsForValue().multiGet(key);
                if (objects == null) {
                    return new HashMap<String, Object>();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator<String> iterator = key.iterator();
                for (Object value : objects) {
                    map.put(iterator.next(), value);
                }
                return map;
            }
            catch (Exception e) {
                return new HashMap<String, Object>();
            }
        }

        public static <E> Map<String, E> getToMap(Collection<String> key, Class<E> requiredType) {
            try {
                List objects = redisTemplate.opsForValue().multiGet(key);
                if (objects == null) {
                    return new HashMap();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator<String> iterator = key.iterator();
                for (Object value : objects) {
                    map.put(iterator.next(), ClassUtils.castValue(value, requiredType));
                }
                return map;
            }
            catch (Exception e) {
                return new HashMap();
            }
        }

        public static void del(String key) {
            try {
                if (key != null && !key.equals("")) {
                    redisTemplate.delete((Object)key);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void del(Collection<String> collection) {
            try {
                if (collection != null && collection.size() > 0) {
                    redisTemplate.delete(collection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void update(String key, Object value) {
            try {
                redisTemplate.opsForValue().set((Object)key, value, 0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

