/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.annotation.Arg;
import cn.omisheep.authz.annotation.Auth;
import cn.omisheep.authz.annotation.AuthData;
import cn.omisheep.authz.annotation.AuthField;
import cn.omisheep.authz.annotation.AuthParam;
import cn.omisheep.authz.core.auth.rpd.DataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.FieldDataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.ParamPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class MetaUtils {
    private MetaUtils() {
        throw new UnsupportedOperationException();
    }

    public static ParamPermRolesMeta generateParamMeta(AuthParam r) {
        if (r == null) {
            return null;
        }
        ParamPermRolesMeta meta = new ParamPermRolesMeta();
        if (r.requireRoles() != null && r.requireRoles().length != 0) {
            meta.setRequireRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.requireRoles()));
        }
        if (r.excludeRoles() != null && r.excludeRoles().length != 0) {
            meta.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.excludeRoles()));
        }
        if (r.requirePermissions() != null && r.requirePermissions().length != 0) {
            meta.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])r.requirePermissions()));
        }
        if (r.excludePermissions() != null && r.excludePermissions().length != 0) {
            meta.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])r.excludePermissions()));
        }
        if (r.resources() != null && r.resources().length != 0) {
            meta.setResources(CollectionUtils.ofSet((Object[])r.resources()));
        }
        if (r.range() != null && r.range().length != 0) {
            meta.setRange(CollectionUtils.ofSet((Object[])r.range()));
        }
        return meta;
    }

    public static void generateParamMeta(DataPermRolesMeta meta, AuthData r) {
        if (r.requireRoles() != null && r.requireRoles().length != 0) {
            meta.setRequireRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.requireRoles()));
        }
        if (r.excludeRoles() != null && r.excludeRoles().length != 0) {
            meta.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.excludeRoles()));
        }
        if (r.requirePermissions() != null && r.requirePermissions().length != 0) {
            meta.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])r.requirePermissions()));
        }
        if (r.excludePermissions() != null && r.excludePermissions().length != 0) {
            meta.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])r.excludePermissions()));
        }
    }

    public static PermRolesMeta generatePermRolesMeta(Set<Auth> auths) {
        if (auths.isEmpty()) {
            return null;
        }
        PermRolesMeta prm = new PermRolesMeta();
        auths.forEach(auth -> prm.merge(MetaUtils.generatePermRolesMeta(auth.requireRoles(), auth.excludeRoles(), auth.requirePermissions(), auth.excludePermissions())));
        return !prm.non() ? prm : null;
    }

    public static PermRolesMeta generatePermRolesMeta(Auth auth) {
        return MetaUtils.generatePermRolesMeta(CollectionUtils.newSet((Object[])new Auth[]{auth}));
    }

    public static <A extends Annotation> A getAnnotation(Object value, Class<A> clz) {
        Annotation annotation = AnnotatedElementUtils.getMergedAnnotation(value.getClass(), clz);
        try {
            if (annotation == null) {
                return (A)AnnotatedElementUtils.getMergedAnnotation(Class.forName(MetaUtils.getTypeName(value)), clz);
            }
            return (A)annotation;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <A extends Annotation> Set<A> getAnnotations(Object value, Class<A> clz) {
        Set annotations = AnnotatedElementUtils.getAllMergedAnnotations(value.getClass(), clz);
        try {
            if (annotations.isEmpty()) {
                return AnnotatedElementUtils.getAllMergedAnnotations(Class.forName(MetaUtils.getTypeName(value)), clz);
            }
            return annotations;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTypeName(Object value) {
        String name = value.getClass().getTypeName();
        int i = name.indexOf(36);
        if (i != -1) {
            return name.substring(0, name.indexOf("$"));
        }
        return name;
    }

    public static Set<String> getPatterns(RequestMappingInfo info) {
        try {
            return info.getPatternsCondition().getPatterns();
        }
        catch (Exception e) {
            return (Set)RequestMappingInfo.class.getMethod("getPatternValues", new Class[0]).invoke((Object)info, new Object[0]);
        }
    }

    public static DataPermRolesMeta generateDataRolesMeta(AuthData authData) {
        Arg[] conditionArgs;
        DataPermRolesMeta dataPermRolesMeta = DataPermRolesMeta.of(authData.condition());
        for (Arg arg : conditionArgs = authData.args()) {
            String resource = arg.resource();
            String[] resourceArgs = arg.args();
            dataPermRolesMeta.addArg(resource, resourceArgs);
        }
        MetaUtils.generateParamMeta(dataPermRolesMeta, authData);
        return dataPermRolesMeta;
    }

    public static FieldDataPermRolesMeta generateDataFiledRolesMeta(String className, AuthField authField) {
        if (authField == null) {
            return null;
        }
        ParamPermRolesMeta meta = new ParamPermRolesMeta();
        if (authField.requireRoles() != null && authField.requireRoles().length != 0) {
            meta.setRequireRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])authField.requireRoles()));
        }
        if (authField.excludeRoles() != null && authField.excludeRoles().length != 0) {
            meta.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])authField.excludeRoles()));
        }
        if (authField.requirePermissions() != null && authField.requirePermissions().length != 0) {
            meta.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])authField.requirePermissions()));
        }
        if (authField.excludePermissions() != null && authField.excludePermissions().length != 0) {
            meta.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])authField.excludePermissions()));
        }
        return FieldDataPermRolesMeta.of(className, meta);
    }

    public static PermRolesMeta generatePermRolesMeta(String[] requireRoles, String[] excludeRoles, String[] requirePermissions, String[] excludePermissions) {
        PermRolesMeta prm = new PermRolesMeta();
        if (requireRoles.length != 0) {
            prm.setRequireRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])requireRoles));
        }
        if (excludeRoles.length != 0) {
            prm.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])excludeRoles));
        }
        if (requirePermissions.length != 0) {
            prm.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])requirePermissions));
        }
        if (excludePermissions.length != 0) {
            prm.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])excludePermissions));
        }
        return !prm.non() ? prm : null;
    }

    public static boolean isController(Object value) {
        try {
            Class<?> aClass = Class.forName(MetaUtils.getTypeName(value));
            if (AnnotationUtils.getAnnotation(aClass, Controller.class) == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

