/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.LogLevel;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.util.FormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"authz.global.log");
    private static LogLevel logLevel;
    private static final Marker MARKER;
    private static final ThreadLocal<List<LogMeta>> logs;
    private static final String DEBUG = "[DEBUG] {}";

    private LogUtils() {
        throw new UnsupportedOperationException();
    }

    public static void info(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.INFO.ordinal() && log.isInfoEnabled(MARKER)) {
            log.info(MARKER, msg, args);
        }
    }

    public static void warn(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.WARN.ordinal() && log.isWarnEnabled(MARKER)) {
            log.warn(MARKER, msg, args);
        }
    }

    public static void debug(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.DEBUG.ordinal() && log.isInfoEnabled(MARKER)) {
            log.info(MARKER, DEBUG, (Object)FormatUtils.format(msg, args));
        }
    }

    public static void error(String msg, Object ... args) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal() && log.isErrorEnabled(MARKER)) {
            log.error(MARKER, msg, args);
        }
    }

    public static void error(Throwable throwable) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal() && log.isErrorEnabled(MARKER)) {
            log.error(MARKER, throwable.getMessage(), throwable);
        }
    }

    public static void error(String msg, Throwable throwable) {
        if (logLevel.ordinal() <= LogLevel.ERROR.ordinal() && log.isErrorEnabled(MARKER)) {
            log.error(MARKER, msg, throwable);
        }
    }

    public static void push(String formatMsg, Object ... args) {
        LogUtils.push(LogLevel.INFO, formatMsg, args);
    }

    public static void push(LogLevel logLevel, String formatMsg, Object ... args) {
        if (LogUtils.logLevel.ordinal() > logLevel.ordinal()) {
            return;
        }
        logs.get().add(new LogMeta(logLevel, formatMsg, args));
    }

    public static void export() {
        if (logLevel.equals((Object)LogLevel.OFF)) {
            return;
        }
        List<LogMeta> logMetas = logs.get();
        if (logMetas == null) {
            return;
        }
        StringBuilder info = new StringBuilder();
        StringBuilder warn = new StringBuilder();
        StringBuilder debug = new StringBuilder();
        StringBuilder error = new StringBuilder();
        logMetas.forEach(logMeta -> {
            switch (((LogMeta)logMeta).logLevel) {
                case INFO: {
                    info.append("\n").append(logMeta);
                    break;
                }
                case WARN: {
                    warn.append("\n").append(logMeta);
                    break;
                }
                case DEBUG: {
                    debug.append("\n").append(logMeta);
                    break;
                }
                case ERROR: {
                    error.append("\n").append(logMeta);
                }
            }
        });
        if (info.length() > 0) {
            LogUtils.info(info.toString(), new Object[0]);
        }
        if (warn.length() > 0) {
            LogUtils.warn(warn.toString(), new Object[0]);
        }
        if (debug.length() > 0) {
            LogUtils.debug(debug.toString(), new Object[0]);
        }
        if (error.length() > 0) {
            LogUtils.error(error.toString(), new Object[0]);
        }
        logMetas.clear();
    }

    public static void logs(String status, HttpMeta httpMeta, PermRolesMeta meta) {
        AccessToken accessToken = httpMeta.getToken();
        if (accessToken == null) {
            httpMeta.log("\u300c{}\u300d\t{}", status, meta);
        } else {
            httpMeta.log("\u300c{}\u300d\t\t{}\t, userId: [{}]\t, deviceType = [{}]\t, deviceId = [{}]", status, meta, accessToken.getUserId(), accessToken.getDeviceType(), accessToken.getDeviceId());
        }
    }

    public static void logs(String status, HttpMeta httpMeta) {
        AccessToken accessToken = httpMeta.getToken();
        if (accessToken == null) {
            httpMeta.log("\u300c{}\u300d", status);
        } else {
            httpMeta.log("\u300c{}\u300d\t, userId: [{}]\t, deviceType = [{}]\t, deviceId = [{}]", status, accessToken.getUserId(), accessToken.getDeviceType(), accessToken.getDeviceId());
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        LogUtils.logLevel = logLevel;
    }

    static {
        MARKER = MarkerFactory.getMarker((String)"cn.omisheep.authz");
        logs = ThreadLocal.withInitial(ArrayList::new);
    }

    public static class LogMeta {
        private final LogLevel logLevel;
        private final String format;
        private final Object[] objects;

        public LogMeta(LogLevel logLevel, String format, Object ... objects) {
            if (logLevel == null) {
                logLevel = LogLevel.INFO;
            }
            this.logLevel = logLevel;
            this.format = format;
            this.objects = objects;
        }

        public String toString() {
            return FormatUtils.format(this.format, this.objects);
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public String getFormat() {
            return this.format;
        }

        public Object[] getObjects() {
            return this.objects;
        }
    }
}

