/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.commons.util.StringUtils;
import cn.omisheep.commons.util.web.JSONUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtils {
    private static final Pattern JSON_RSA_PATTERN = Pattern.compile("\\{.*\".*\".*:.*\"(.*)\".*}");

    private FormatUtils() {
        throw new UnsupportedOperationException();
    }

    public static String parseRSAJson(String json) {
        Matcher matcher = JSON_RSA_PATTERN.matcher(json);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String beautifulJson(Object o) {
        return JSONUtils.toPrettyJSONString((Object)o);
    }

    public static String format(String format, Object ... vals) {
        return StringUtils.format((String)format, (Object[])vals);
    }

    public static boolean isIgnoreSuffix(String uri, String ... suffix) {
        for (String s : suffix) {
            if (!uri.endsWith(s)) continue;
            return true;
        }
        return false;
    }
}

