/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.auth.rpd.ArgsHandler;
import cn.omisheep.authz.core.auth.rpd.DataPermRolesMeta;
import cn.omisheep.authz.core.util.LogUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArgsParser {
    private static final Pattern c = Pattern.compile("[#$]?\\{(.*?)}");
    private static final Pattern compile = Pattern.compile("(.*?)\\[(\\d+|\\*)]");

    private ArgsParser() {
        throw new UnsupportedOperationException();
    }

    public static Object parse(String argName) {
        return ArgsParser.parse(argName, null);
    }

    public static <E> Object parse(String argName, Supplier<E> fail) {
        Matcher matcher = c.matcher(argName);
        if (!matcher.find()) {
            if (fail == null) {
                return argName;
            }
            return fail.get();
        }
        String obj = matcher.group(1);
        String[] trace = obj.split("\\.");
        Object convert = ArgsParser.convert(trace, ArgsHandler.handle(trace[0], new Object[0]));
        if (ArgsParser.isArrayOrCollection(convert)) {
            String arrString = ArgsParser.parseAndToString(convert);
            if (arrString == null) {
                return argName;
            }
            return Arrays.stream(arrString.substring(1, arrString.length() - 1).trim().split(",")).map(String::trim).collect(Collectors.toList());
        }
        return convert;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parse(DataPermRolesMeta dataPermRolesMeta) {
        StringBuilder stringBuilder = new StringBuilder();
        String condition = dataPermRolesMeta.getCondition();
        int index = 0;
        int i = 0;
        char op = '#';
        while (true) {
            block10: {
                int k;
                if (index == -1) {
                    return null;
                }
                if (i % 2 == 0) {
                    k = condition.indexOf("{", index);
                    if (k != -1) {
                        char o = k - 1 < 0 ? (char)'#' : (char)condition.charAt(k - 1);
                        if (o == '#' || o == '$') {
                            op = o;
                            stringBuilder.append(condition, index, k - 1);
                        } else {
                            stringBuilder.append(condition, index, k);
                        }
                        index = k;
                        break block10;
                    } else {
                        if (condition.indexOf("}", index) != -1) {
                            return null;
                        }
                        if (stringBuilder.length() == 0) {
                            return condition;
                        }
                        return ArgsParser.reduce(stringBuilder.append(condition, index, condition.length()).toString());
                    }
                }
                k = condition.indexOf("}", index);
                if (k == -1) {
                    return null;
                }
                String item = condition.substring(index + 1, k);
                String[] trace = item.split("\\.");
                stringBuilder.append(ArgsParser.parseObject(op, trace, ArgsParser.ref(trace[0], dataPermRolesMeta)));
                index = k + 1;
            }
            ++i;
        }
    }

    private static String reduce(String s) {
        char[] chars = s.toCharArray();
        StringBuilder builder = new StringBuilder();
        int is = 0;
        boolean in = false;
        for (int i = 0; i < chars.length; ++i) {
            if (i + 2 < chars.length && s.substring(i, i + 2).equalsIgnoreCase("in")) {
                in = true;
            }
            if (in) {
                if (chars[i] == '(') {
                    if (++is > 1) {
                        continue;
                    }
                } else if (chars[i] == ')') {
                    if (--is != 0) continue;
                    in = false;
                }
            }
            builder.append(chars[i]);
        }
        return builder.toString();
    }

    private static Object ref(String argName, DataPermRolesMeta dataPermRolesMeta) {
        Map<String, List<String>> argsMap = dataPermRolesMeta.getArgsMap();
        if (argsMap == null) {
            return ArgsParser.argsHandle(argName, new Object[0]);
        }
        List<String> list = dataPermRolesMeta.getArgsMap().get(argName);
        if (list == null || list.isEmpty()) {
            return ArgsParser.argsHandle(argName, new Object[0]);
        }
        ArrayList<Object> argsList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Matcher matcher = c.matcher(list.get(i));
            if (matcher.find()) {
                argsList.add(ArgsParser.ref(matcher.group(1), dataPermRolesMeta));
                continue;
            }
            List<Class<?>> paramType = ArgsHandler.argParameterList(argName);
            if (paramType == null) {
                throw new RuntimeException("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d");
            }
            Class<?> aClass = paramType.get(i);
            try {
                argsList.add(aClass.getConstructor(String.class).newInstance(list.get(i)));
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LogUtils.error(e);
            }
        }
        return ArgsParser.argsHandle(argName, argsList.toArray());
    }

    private static String parseObject(char op, String[] trace, Object value) {
        if (op == '#') {
            if (value == null) {
                return "";
            }
            Object convert = ArgsParser.convert(trace, value);
            if (ArgsParser.isArrayOrCollection(convert)) {
                return ArgsParser.parseAndToString(convert);
            }
            return convert.toString();
        }
        if (op == '$') {
            return ArgsParser.parseObject('#', trace, value);
        }
        return ArgsParser.parseObject('#', trace, value);
    }

    private static Object argsHandle(String argName, Object ... otherArgs) {
        return ArgsHandler.handle(argName, otherArgs);
    }

    private static Object convert(String[] trace, Object obj) {
        Matcher matcher;
        boolean isObject;
        if (trace.length == 1) {
            return obj;
        }
        Object json = JSON.toJSON((Object)obj);
        JSONObject o = null;
        JSONArray a = null;
        if (json instanceof JSONObject) {
            isObject = true;
            o = (JSONObject)json;
        } else {
            isObject = false;
            a = (JSONArray)json;
        }
        for (int i = 1; i < trace.length - 1; ++i) {
            matcher = compile.matcher(trace[i]);
            if (matcher.find()) {
                if (matcher.group(2).equals("*")) {
                    a = isObject ? o.getJSONArray(matcher.group(1)) : new JSONArray(ArgsParser.collect((List<Object>)a, matcher.group(1)));
                    isObject = false;
                    continue;
                }
                int ii = Integer.parseInt(matcher.group(2));
                if (isObject) {
                    o = (JSONObject)o.getJSONArray(matcher.group(1)).get(ii);
                    continue;
                }
                a = new JSONArray(ArgsParser.collect((List<Object>)a, matcher.group(1), ii));
                continue;
            }
            if (isObject) {
                Object o1 = o.get((Object)trace[i]);
                if (o1 instanceof JSONObject) {
                    o = (JSONObject)o1;
                    continue;
                }
                a = (JSONArray)o1;
                isObject = false;
                continue;
            }
            a = new JSONArray(ArgsParser.collect((List<Object>)a, trace[i]));
        }
        String v = trace[trace.length - 1];
        matcher = compile.matcher(v);
        if (!isObject) {
            if (matcher.find()) {
                if (matcher.group(2).equals("*")) {
                    return ArgsParser.collect((List<Object>)a, matcher.group(1));
                }
                return ArgsParser.collect((List<Object>)a, matcher.group(1), Integer.parseInt(matcher.group(2)));
            }
            return ArgsParser.collect((List<Object>)a, v);
        }
        Object value = matcher.find() ? (matcher.group(2).equals("*") ? o.getJSONArray(matcher.group(1)) : o.getJSONArray(matcher.group(1)).get(Integer.parseInt(matcher.group(2)))) : o.get((Object)v);
        return value;
    }

    private static List<Object> collect(List<Object> a, String name, int i) {
        return a.stream().flatMap(jo -> {
            if (jo == null) {
                return null;
            }
            if (jo instanceof JSONObject) {
                return Stream.of(((JSONObject)jo).getJSONArray(name).get(i));
            }
            return ((JSONArray)jo).stream().map(jox -> ((JSONObject)jox).getJSONArray(name).get(i));
        }).collect(Collectors.toList());
    }

    private static List<Object> collect(List<Object> a, String name) {
        return a.stream().flatMap(jo -> {
            if (jo == null) {
                return null;
            }
            if (jo instanceof JSONObject) {
                return Stream.of(((JSONObject)jo).get((Object)name));
            }
            return ((JSONArray)jo).stream().map(jox -> ((JSONObject)jox).get((Object)name));
        }).collect(Collectors.toList());
    }

    private static boolean isArrayOrCollection(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof Collection || o.getClass().isArray();
    }

    private static String parseAndToString(Object o) {
        if (!ArgsParser.isArrayOrCollection(o)) {
            return null;
        }
        if (o.getClass().isArray()) {
            if (o instanceof int[]) {
                return ArgsParser.parseArray((int[])o);
            }
            if (o instanceof long[]) {
                return ArgsParser.parseArray((long[])o);
            }
            if (o instanceof float[]) {
                return ArgsParser.parseArray((float[])o);
            }
            if (o instanceof double[]) {
                return ArgsParser.parseArray((double[])o);
            }
            if (o instanceof char[]) {
                return ArgsParser.parseArray((char[])o);
            }
            if (o instanceof boolean[]) {
                return ArgsParser.parseArray((boolean[])o);
            }
            if (o instanceof short[]) {
                return ArgsParser.parseArray((short[])o);
            }
            if (o instanceof String[]) {
                return ArgsParser.parseArray((String[])o);
            }
            return ArgsParser.parseArray((Object[])o);
        }
        if (o instanceof Collection) {
            return ArgsParser.parseArray((Collection)o);
        }
        return null;
    }

    private static String parseArray(short[] a) {
        if (a == null) {
            return null;
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(int[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(long[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(float[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(double[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(char[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(boolean[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(String[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(Object[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(" )").toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String parseArray(Collection<?> collection) {
        if (collection == null) {
            return "";
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("( ");
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof String || next instanceof Character || next.equals(Character.TYPE)) {
                b.append("'").append(next).append("'");
            } else {
                b.append(next);
            }
            if (iterator.hasNext()) {
                b.append(", ");
                continue;
            }
            b.append(")");
        }
        return b.toString();
    }
}

