/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.tk;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.TokenException;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.authz.core.oauth.AuthorizationInfo;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.tk.GrantType;
import cn.omisheep.authz.core.tk.IssueToken;
import cn.omisheep.authz.core.tk.RefreshToken;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.UUIDBits;
import cn.omisheep.web.utils.HttpUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class TokenHelper
extends BaseHelper {
    private static final Long accessTime;
    private static final Long refreshTime;
    private static final int expire;
    private static final String cookieName;
    private static final SecretKey secretKey;
    private static final SignatureAlgorithm alg;
    private static final CompressionCodec codec;
    private static final int tokenIdBits;
    private static final String prefix;

    private TokenHelper() {
        throw new UnsupportedOperationException();
    }

    public static TokenPair createTokenPair(AuthorizationInfo info) {
        return TokenHelper.createTokenPair(info.getUserId(), null, null, info.getClientId(), info.getScope(), info.getGrantType());
    }

    public static TokenPair createTokenPair(Object userId, String deviceType, String deviceId) {
        return TokenHelper.createTokenPair(userId, deviceType, deviceId, null, null, null);
    }

    public static TokenPair createTokenPair(Object userId, String deviceType, String deviceId, String clientId, String scope, GrantType grantType) {
        Date now = TimeUtils.now();
        Date toAccessExpiredTime = TimeUtils.datePlus((Date)now, (long)accessTime);
        Date toRefreshExpiredTime = TimeUtils.datePlus((Date)now, (long)refreshTime);
        String id = UUIDBits.getUUIDBits((int)tokenIdBits);
        String accessTokenId = UUIDBits.getUUIDBits((int)tokenIdBits);
        return TokenHelper.createTokenPair(userId, deviceType, deviceId, clientId, scope, grantType, accessTokenId, id, toAccessExpiredTime, toRefreshExpiredTime);
    }

    public static TokenPair createTokenPair(Object userId, String deviceType, String deviceId, String clientId, String scope, GrantType grantType, String accessTokenId, String id, Date toAccessExpiredTime, Date toRefreshExpiredTime) {
        AccessToken accessToken = TokenHelper.createAccessToken(userId, deviceType, deviceId, accessTokenId, id, toAccessExpiredTime, clientId, scope, grantType);
        RefreshToken refreshToken = TokenHelper.createRefreshToken(accessToken, toRefreshExpiredTime);
        return new TokenPair(accessToken, refreshToken);
    }

    private static AccessToken createAccessToken(Object userId, String deviceType, String deviceId, String accessTokenId, String id, Date expiresAt, String clientId, String scope, GrantType grantType) {
        Claims claims = Jwts.claims();
        claims.put((Object)"uid", userId);
        claims.put((Object)"tid", (Object)id);
        if (clientId != null) {
            if (grantType != null) {
                claims.put((Object)"gtp", (Object)grantType.getType());
            }
            if (scope != null) {
                claims.put((Object)"cop", (Object)scope);
            }
            claims.put((Object)"cid", (Object)clientId);
        } else {
            claims.put((Object)"did", (Object)deviceId);
            claims.put((Object)"dtp", (Object)deviceType);
        }
        JwtBuilder jwtBuilder = Jwts.builder().setClaims(claims).setId(accessTokenId).compressWith(codec).setExpiration(expiresAt);
        if (secretKey != null) {
            jwtBuilder.signWith((Key)secretKey, alg);
        }
        String tokenVal = jwtBuilder.compact();
        return new AccessToken(id, tokenVal.substring(tokenVal.indexOf(".") + 1), accessTokenId, accessTime, expiresAt.getTime(), grantType, clientId, scope, userId, deviceType, deviceId);
    }

    private static RefreshToken createRefreshToken(AccessToken accessToken, Date expiresAt) {
        Claims claims = Jwts.claims();
        claims.put((Object)"uid", accessToken.getUserId());
        claims.put((Object)"cid", (Object)accessToken.getClientId());
        JwtBuilder jwtBuilder = Jwts.builder().setClaims(claims).setId(accessToken.getId()).setExpiration(expiresAt).compressWith(codec);
        if (secretKey != null) {
            jwtBuilder.signWith((Key)secretKey, alg);
        }
        String tokenVal = jwtBuilder.compact();
        return new RefreshToken(accessToken.getId(), tokenVal.substring(tokenVal.indexOf(".") + 1), refreshTime, expiresAt.getTime(), accessToken.getUserId(), accessToken.getClientId());
    }

    public static TokenPair refreshToken(String refreshToken) throws TokenException {
        return TokenHelper.refreshToken(TokenHelper.parseRefreshToken(refreshToken));
    }

    public static TokenPair refreshToken(RefreshToken refreshToken) {
        if (refreshToken == null) {
            return null;
        }
        String clientId = refreshToken.getClientId();
        Device device = clientId == null ? cache.get(Constants.USER_DEVICE_KEY_PREFIX.get() + refreshToken.getUserId() + ":" + refreshToken.getId(), Device.class) : cache.get(Constants.OAUTH_USER_DEVICE_KEY_PREFIX.get() + refreshToken.getUserId() + ":" + refreshToken.getId(), Device.class);
        if (device == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        Date toAccessExpiredTime = Date.from(now.plus(accessTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
        return TokenHelper.createTokenPair(refreshToken.getUserId(), device.getDeviceType(), device.getDeviceId(), device.getClientId(), device.getScope(), device.getGrantType(), device.getAccessTokenId(), refreshToken.getId(), toAccessExpiredTime, new Date(refreshToken.getExpiresAt()));
    }

    public static Cookie generateCookie(AccessToken token) {
        if (token == null) {
            return null;
        }
        Cookie cookie = new Cookie(cookieName, token.getToken());
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(expire);
        return cookie;
    }

    public static void clearCookie(HttpServletResponse response) {
        if (response == null) {
            return;
        }
        Cookie cookie = new Cookie(cookieName, null);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static void clearCookie() {
        TokenHelper.clearCookie(HttpUtils.getCurrentResponse());
    }

    private static Claims parseToken(String val) {
        if (val == null || val.equals("")) {
            return null;
        }
        return (Claims)Jwts.parserBuilder().setSigningKey((Key)secretKey).build().parseClaimsJws(prefix + val).getBody();
    }

    public static AccessToken parseAccessToken(String accessToken) throws TokenException {
        Claims claims = TokenHelper.parseToken(accessToken);
        if (claims == null || claims.get("tid", String.class) == null) {
            throw new TokenException();
        }
        return new AccessToken((String)claims.get("tid", String.class), accessToken, claims.getId(), null, claims.getExpiration().getTime(), GrantType.grantType((String)claims.get("gtp", String.class)), (String)claims.get("cid", String.class), (String)claims.get("cop", String.class), claims.get((Object)"uid"), (String)claims.get("dtp", String.class), (String)claims.get("did", String.class));
    }

    public static RefreshToken parseRefreshToken(String refreshToken) throws TokenException {
        Claims claims = TokenHelper.parseToken(refreshToken);
        if (claims == null) {
            throw new TokenException();
        }
        return new RefreshToken(refreshToken, claims.getId(), null, claims.getExpiration().getTime(), claims.get((Object)"uid"), (String)claims.get("cid", String.class));
    }

    public static IssueToken createIssueToken(TokenPair tokenPair) {
        GrantType grantType = tokenPair.getAccessToken().getGrantType();
        IssueToken token = new IssueToken().setAccessToken(tokenPair.getAccessToken().getToken()).setScope(tokenPair.getAccessToken().getScope()).setExpiresIn(tokenPair.getAccessToken().getExpiresIn());
        if (!GrantType.CLIENT_CREDENTIALS.equals((Object)grantType)) {
            return token.setRefreshToken(tokenPair.getRefreshToken().getToken());
        }
        return token;
    }

    static {
        String prefix1;
        codec = CompressionCodecs.GZIP;
        AuthzProperties.TokenConfig token = properties.getToken();
        String key = token.getKey();
        tokenIdBits = token.getTokenIdBits();
        if (key == null || key.equals("")) {
            secretKey = null;
            alg = SignatureAlgorithm.NONE;
        } else {
            StringBuilder stringBuilder = new StringBuilder(key);
            if (stringBuilder.length() * 8 < SignatureAlgorithm.HS256.getMinKeyLength()) {
                while (stringBuilder.length() * 8 < SignatureAlgorithm.HS256.getMinKeyLength()) {
                    stringBuilder.append(".");
                }
            }
            secretKey = Keys.hmacShaKeyFor((byte[])stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
            alg = SignatureAlgorithm.HS256;
        }
        JwsHeader jwsHeader = Jwts.jwsHeader();
        if (alg != SignatureAlgorithm.NONE) {
            jwsHeader.setAlgorithm(alg.getValue());
        }
        jwsHeader.setCompressionAlgorithm(codec.getAlgorithmName());
        try {
            byte[] bytes = new ObjectMapper().writeValueAsBytes((Object)jwsHeader);
            prefix1 = (String)Encoders.BASE64URL.encode((Object)bytes) + ".";
        }
        catch (JsonProcessingException e) {
            LogUtils.error(e);
            prefix1 = "";
        }
        prefix = prefix1;
        cookieName = properties.getToken().getCookieName();
        accessTime = TimeUtils.parseTimeValue((String)token.getAccessTime());
        refreshTime = TimeUtils.parseTimeValue((String)token.getRefreshTime());
        expire = (int)(accessTime / 1000L);
    }
}

