/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.LogLevel;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.ipf.RequestMeta;
import cn.omisheep.authz.core.msg.RequestMessage;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Async;
import org.springframework.web.method.HandlerMethod;

@Order(value=10)
public class RateLimitSlot
implements Slot {
    private final AuthzProperties properties;

    public RateLimitSlot(AuthzProperties properties) {
        this.properties = properties;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        RequestMeta requestMeta;
        String ip = httpMeta.getIp();
        long now = httpMeta.getNow().getTime();
        String method = httpMeta.getMethod();
        String path = httpMeta.getServletPath();
        String api = httpMeta.getApi();
        LimitMeta limitMeta = Httpd.getLimitMetadata(method, api);
        Object userId = null;
        String deviceType = null;
        String deviceId = null;
        String clientId = null;
        if (httpMeta.hasToken()) {
            userId = httpMeta.getToken().getUserId();
            deviceType = httpMeta.getToken().getDeviceType();
            deviceId = httpMeta.getToken().getDeviceId();
            clientId = httpMeta.getToken().getClientId();
        }
        if (limitMeta == null) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee\u300d \t api: [{}] , path: [{}] , method: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}] , path: [{}]  ", api, path, method, ip, clientId, userId, deviceType, deviceId);
            return;
        }
        if (this.properties.getCache().isEnableRedis()) {
            RequestMessage requestMessage = new RequestMessage(method, api, ip, userId, now);
            Async.run(() -> RedisUtils.publish(RequestMessage.CHANNEL, requestMessage));
        }
        RateLimit.CheckType checkType = limitMeta.getCheckType();
        Httpd.RequestPool ipRequestPool = Httpd.getIpRequestPools(api, method);
        Httpd.RequestPool userIdRequestPool = Httpd.getUserIdRequestPool(api, method);
        if (checkType.equals((Object)RateLimit.CheckType.USER_ID) && userId == null) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee\u300d \t api: [{}] , path: [{}] , method: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}] , path: [{}]  ", api, path, method, ip, clientId, null, deviceType, deviceId);
            return;
        }
        if (ipRequestPool == null || userIdRequestPool == null) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee\u300d \t api: [{}] , path: [{}] , method: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}] , path: [{}]  ", api, path, method, ip, clientId, userId, deviceType, deviceId);
            return;
        }
        RequestMeta requestMeta2 = requestMeta = checkType.equals((Object)RateLimit.CheckType.IP) ? (RequestMeta)ipRequestPool.get(ip) : (RequestMeta)userIdRequestPool.get(userId.toString());
        if (requestMeta != null && requestMeta.isBan()) {
            if (!requestMeta.enableRelive(now)) {
                httpMeta.log(LogLevel.WARN, "\u300c\u8bf7\u6c42\u9891\u7e41\u3001{}\u5c01\u9501(\u62d2\u7edd)\u300d \t api: [{}] , path: [{}] , \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}] , path: [{}]  ", new Object[]{checkType, api, path, requestMeta.sinceLastTime(), method, ip, clientId, userId, deviceType, deviceId});
                error.error(new Object[]{ExceptionStatus.REQUEST_REPEAT});
                requestMeta.setLastRequestTime(now);
                return;
            }
            httpMeta.log("\u300c\u89e3\u9664{}\u5c01\u7981(\u89e3\u5c01)\u300d \t api: [{}] , path: [{}] , \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}]  ", new Object[]{checkType, api, path, requestMeta.sinceLastTime(), method, ip, clientId, userId, deviceType, deviceId});
            Httpd.relive(requestMeta, limitMeta, method, api);
        }
        if (requestMeta == null) {
            if (checkType.equals((Object)RateLimit.CheckType.IP)) {
                ipRequestPool.put(ip, new RequestMeta(now, ip, null));
            } else {
                userIdRequestPool.put(userId.toString(), new RequestMeta(now, null, userId));
            }
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee(\u9996\u6b21)\u300d \t method: [{}] , api: [{}] , path: [{}] , ip : [{}] , clientId : [{}] , userId: [{}] , deviceType: [{}] , deviceId: [{}] ", method, api, path, ip, clientId, userId, deviceType, deviceId);
        } else if (requestMeta.request(now, limitMeta.getMaxRequests(), limitMeta.getWindow(), limitMeta.getMinInterval())) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee(\u6b63\u5e38)\u300d \t \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , api: [{}] , path: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}] , path: [{}]  ", requestMeta.sinceLastTime(), api, path, method, ip, clientId, userId, deviceType, deviceId);
        } else {
            Httpd.forbid(now, requestMeta, limitMeta, method, api);
            httpMeta.log(LogLevel.WARN, "\u300c\u8bf7\u6c42\u9891\u7e41\u3001{}\u5c01\u9501(\u5c01\u7981)\u300d \t api: [{}] , path: [{}] , \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , clientId : [{}] , userId : [{}] , deviceType: [{}] , deviceId: [{}] ", new Object[]{checkType, api, path, requestMeta.sinceLastTime(), method, ip, clientId, userId, deviceType, deviceId});
            error.error(new Object[]{ExceptionStatus.REQUEST_REPEAT});
        }
    }
}

