/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.ParamPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.ValueMatcher;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

@Order(value=400)
public class ParameterPermSlot
implements Slot {
    private final PermLibrary permLibrary;

    public ParameterPermSlot(PermLibrary permLibrary) {
        this.permLibrary = permLibrary;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (!httpMeta.isHasParamAuth()) {
            return;
        }
        Map<String, ParamMetadata> paramPeMap = PermissionDict.getParamPermission().get(httpMeta.getApi()).get(httpMeta.getMethod());
        Set<String> roles = null;
        Set<String> permissions = null;
        for (MethodParameter parameter : handler.getMethodParameters()) {
            List<ParamPermRolesMeta> paramMetaList;
            ParamMetadata paramMetadata;
            RequestParam requestParam = (RequestParam)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), RequestParam.class);
            PathVariable pathVariable = (PathVariable)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), PathVariable.class);
            if (requestParam == null && pathVariable == null) continue;
            String value = null;
            String paramName = parameter.getParameter().getName();
            if (pathVariable != null) {
                if (!pathVariable.name().equals("")) {
                    paramName = pathVariable.name();
                }
                Map pathVariables = (Map)httpMeta.getRequest().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
                value = (String)pathVariables.get(paramName);
            } else {
                if (!requestParam.name().equals("")) {
                    paramName = requestParam.name();
                }
                value = httpMeta.getRequest().getParameter(paramName);
            }
            if (value == null || (paramMetadata = paramPeMap.get(paramName)) == null || (paramMetaList = paramMetadata.getParamMetaList()) == null || paramMetaList.isEmpty()) continue;
            if (!httpMeta.hasToken()) {
                LogUtils.logs("Require Login", httpMeta);
                error.error(new Object[]{ExceptionStatus.REQUIRE_LOGIN});
                return;
            }
            if (roles == null) {
                roles = httpMeta.getRoles();
            }
            if (permissions == null) {
                permissions = httpMeta.getPermissions();
            }
            List resourcesMeta = paramMetaList.stream().filter(meta -> meta.getResources() != null).collect(Collectors.toList());
            List rangeMeta = paramMetaList.stream().filter(meta -> meta.getRange() != null).collect(Collectors.toList());
            boolean next_resources = true;
            boolean next_range = true;
            String paramTypeName = parameter.getParameter().getType().getTypeName();
            ValueMatcher.ValueType valueType = paramMetadata.getValueMatchType();
            for (ParamPermRolesMeta meta2 : resourcesMeta) {
                if (!ValueMatcher.match(meta2.getResources(), value, paramTypeName, valueType) || CollectionUtils.containsSub(meta2.getRequireRoles(), roles) && !CollectionUtils.containsSub(meta2.getExcludeRoles(), roles) && CollectionUtils.containsSub(meta2.getRequirePermissions(), permissions) && !CollectionUtils.containsSub(meta2.getExcludePermissions(), permissions)) continue;
                next_resources = false;
                break;
            }
            boolean flag = false;
            for (ParamPermRolesMeta meta3 : rangeMeta) {
                if (!CollectionUtils.containsSub(meta3.getRequireRoles(), roles) && CollectionUtils.containsSub(meta3.getExcludeRoles(), roles) && !CollectionUtils.containsSub(meta3.getRequirePermissions(), permissions) && CollectionUtils.containsSub(meta3.getExcludePermissions(), permissions)) continue;
                next_range = false;
                if (!ValueMatcher.match(meta3.getRange(), value, paramTypeName, valueType)) continue;
                flag = true;
                break;
            }
            if (next_resources && (next_range || !next_range && flag)) continue;
            LogUtils.logs("Forbid : permissions exception by request parameter", httpMeta);
            error.error(new Object[]{ExceptionStatus.PERM_EXCEPTION});
            return;
        }
    }
}

