/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.oauth.OpenAuthDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.GrantType;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

@Order(value=50)
public class OAuthSlot
implements Slot {
    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        Set<String> scope;
        GrantType type;
        String method;
        if (!httpMeta.hasToken()) {
            return;
        }
        String clientId = httpMeta.getToken().getClientId();
        if (clientId == null) {
            return;
        }
        String path = httpMeta.getApi();
        if (!OpenAuthDict.target(path, method = httpMeta.getMethod(), type = httpMeta.getToken().getGrantType(), scope = httpMeta.getScope())) {
            error.error(new Object[]{ExceptionStatus.SCOPE_EXCEPTION_OR_TYPE_ERROR});
        }
    }
}

