/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.support.util.IPAddress;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.authz.support.util.IPRangeMeta;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

@Order(value=30)
public class IPRangeSlot
implements Slot {
    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        try {
            if (PermissionDict.isSupportNative() && (httpMeta.getIp().equals("0:0:0:0:0:0:0:1") || httpMeta.getIp().equals("127.0.0.1"))) {
                return;
            }
            if (!this.isPermittedRequest(httpMeta.getIp(), PermissionDict.getGlobalAllow(), PermissionDict.getGlobalDeny())) {
                error.error(new Object[]{ExceptionStatus.PERM_EXCEPTION});
                return;
            }
            IPRangeMeta ipRangeMeta = PermissionDict.getIPRange().get(httpMeta.getApi()).get(httpMeta.getMethod());
            if (ipRangeMeta != null && !this.isPermittedRequest(httpMeta.getIp(), ipRangeMeta.getAllow(), ipRangeMeta.getDeny())) {
                error.error(new Object[]{ExceptionStatus.PERM_EXCEPTION});
                return;
            }
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean isPermittedRequest(String remoteAddress, Set<IPRange> allowList, Set<IPRange> denyList) {
        boolean ipV6;
        boolean bl = ipV6 = remoteAddress.indexOf(58) != -1;
        if (ipV6) {
            return denyList.size() == 0 && allowList.size() == 0;
        }
        IPAddress ipAddress = new IPAddress(remoteAddress);
        for (IPRange range : denyList) {
            if (!range.isIPAddressInRange(ipAddress)) continue;
            return false;
        }
        if (allowList.size() > 0) {
            for (IPRange range : allowList) {
                if (!range.isIPAddressInRange(ipAddress)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

