/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.LogUtils;
import org.springframework.web.method.HandlerMethod;

@Order(value=100)
public class DeviceSlot
implements Slot {
    private final UserDevicesDict userDevicesDict;

    public DeviceSlot(UserDevicesDict userDevicesDict) {
        this.userDevicesDict = userDevicesDict;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (!httpMeta.isRequireLogin()) {
            return;
        }
        if (httpMeta.getUserStatus() != null) {
            if (httpMeta.getUserStatus().equals((Object)UserDevicesDict.UserStatus.ACCESS_TOKEN_OVERDUE)) {
                LogUtils.logs("Forbid : expired token exception", httpMeta);
                error.error(new Object[]{ExceptionStatus.ACCESS_TOKEN_OVERDUE});
            } else if (httpMeta.getUserStatus().equals((Object)UserDevicesDict.UserStatus.REQUIRE_LOGIN)) {
                LogUtils.logs("Require Login", httpMeta);
                error.error(new Object[]{ExceptionStatus.REQUIRE_LOGIN});
            }
            return;
        }
        if (!httpMeta.hasToken()) {
            LogUtils.logs("Require Login", httpMeta);
            error.error(new Object[]{ExceptionStatus.REQUIRE_LOGIN});
            return;
        }
        switch (this.userDevicesDict.userStatus(httpMeta.getToken())) {
            case REQUIRE_LOGIN: {
                LogUtils.logs("Require Login", httpMeta);
                error.error(new Object[]{ExceptionStatus.REQUIRE_LOGIN});
                httpMeta.setUserStatus(UserDevicesDict.UserStatus.REQUIRE_LOGIN);
                return;
            }
            case LOGIN_EXCEPTION: {
                LogUtils.logs("forbid : may have logged in elsewhere", httpMeta);
                error.error(new Object[]{ExceptionStatus.LOGIN_EXCEPTION});
                httpMeta.setUserStatus(UserDevicesDict.UserStatus.LOGIN_EXCEPTION);
                return;
            }
        }
        httpMeta.setUserStatus(UserDevicesDict.UserStatus.SUCCESS);
    }
}

