/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.annotation.AuthRequestToken;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.TokenException;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.tk.TokenHelper;
import cn.omisheep.web.utils.HttpUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import java.lang.reflect.AnnotatedElement;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

@Order(value=1)
public class CookieAndRequestSlot
implements Slot {
    private final UserDevicesDict userDevicesDict;
    private final boolean isEnableRedis;
    private final String cookieName;
    private final String headerName;
    private final String headerPrefix;

    public CookieAndRequestSlot(UserDevicesDict userDevicesDict, PermLibrary permLibrary, AuthzProperties properties) {
        this.userDevicesDict = userDevicesDict;
        this.isEnableRedis = properties.getCache().isEnableRedis();
        this.cookieName = properties.getToken().getCookieName();
        this.headerName = properties.getToken().getHeaderName().toLowerCase(Locale.ROOT);
        this.headerPrefix = properties.getToken().getHeaderPrefix();
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        String s;
        Cookie cookie;
        String tokenValue = null;
        AuthRequestToken authRequestToken = (AuthRequestToken)handler.getMethodAnnotation(AuthRequestToken.class);
        if (authRequestToken == null) {
            authRequestToken = (AuthRequestToken)AnnotationUtils.getAnnotation((AnnotatedElement)handler.getBeanType(), AuthRequestToken.class);
        }
        if (authRequestToken != null) {
            if (!authRequestToken.header().equals("")) {
                tokenValue = (String)HttpUtils.getCurrentRequestHeaders().get(authRequestToken.header().toLowerCase(Locale.ROOT));
            }
            if (tokenValue == null && !authRequestToken.cookie().equals("")) {
                cookie = HttpUtils.readSingleCookieInRequestByName((String)authRequestToken.cookie());
                tokenValue = cookie.getValue();
            }
            if (tokenValue == null && !authRequestToken.param().equals("")) {
                tokenValue = httpMeta.getRequest().getParameter(authRequestToken.param());
            }
            if (tokenValue != null) {
                httpMeta.setClearCookie(false);
            }
        }
        if (tokenValue == null && (s = (String)HttpUtils.getCurrentRequestHeaders().get(this.headerName)) != null && s.startsWith(this.headerPrefix) && (tokenValue = s.substring(this.headerPrefix.length())) != null) {
            httpMeta.setClearCookie(false);
        }
        cookie = HttpUtils.readSingleCookieInRequestByName((String)this.cookieName);
        if (tokenValue == null && cookie != null) {
            tokenValue = cookie.getValue();
        }
        if (tokenValue == null) {
            return;
        }
        try {
            AccessToken accessToken = TokenHelper.parseAccessToken(tokenValue);
            httpMeta.setToken(accessToken);
        }
        catch (Exception e) {
            TokenHelper.clearCookie();
            if (e instanceof JwtException) {
                try {
                    if (e instanceof ExpiredJwtException) {
                        Claims claims = ((ExpiredJwtException)e).getClaims();
                        this.userDevicesDict.removeAccessTokenByTid(claims.get((Object)"uid"), (String)claims.get("tid", String.class));
                        httpMeta.setUserStatus(UserDevicesDict.UserStatus.ACCESS_TOKEN_OVERDUE);
                    }
                    httpMeta.setUserStatus(UserDevicesDict.UserStatus.REQUIRE_LOGIN);
                }
                catch (Exception exception) {}
            }
            if (e instanceof TokenException) {
                httpMeta.setUserStatus(UserDevicesDict.UserStatus.REQUIRE_LOGIN);
                error.error(new Object[]{ExceptionStatus.TOKEN_EXCEPTION});
            }
            error.error(e);
            return;
        }
    }
}

