/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.CollectionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

@Order(value=300)
public class APIPermSlot
implements Slot {
    private final PermLibrary permLibrary;

    public APIPermSlot(PermLibrary permLibrary) {
        this.permLibrary = permLibrary;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (!httpMeta.isHasApiAuth()) {
            return;
        }
        if (!this.check(PermissionDict.getControllerRolePermission().get(httpMeta.getController()), error, httpMeta)) {
            return;
        }
        Map<String, PermRolesMeta> rolesMetaMap1 = PermissionDict.getRolePermission().get(httpMeta.getApi());
        if (rolesMetaMap1 == null || this.check(rolesMetaMap1.get(httpMeta.getMethod()), error, httpMeta)) {
            LogUtils.logs("Success: API", httpMeta);
        }
    }

    private boolean check(PermRolesMeta permRolesMeta, Error error, HttpMeta httpMeta) {
        if (permRolesMeta == null || permRolesMeta.non()) {
            return true;
        }
        Set<String> roles = null;
        if (!CollectionUtils.isEmpty(permRolesMeta.getRequireRoles()) || !CollectionUtils.isEmpty(permRolesMeta.getExcludeRoles())) {
            roles = httpMeta.getRoles();
            if (!CollectionUtils.containsSub(permRolesMeta.getRequireRoles(), roles) || CollectionUtils.containsSub(permRolesMeta.getExcludeRoles(), roles)) {
                LogUtils.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                error.error(new Object[]{ExceptionStatus.PERM_EXCEPTION});
                return false;
            }
        }
        if (!CollectionUtils.isEmpty(permRolesMeta.getRequirePermissions()) || !CollectionUtils.isEmpty(permRolesMeta.getExcludePermissions())) {
            HashSet<String> perms = new HashSet<String>();
            for (String role : (Set)Optional.ofNullable(httpMeta.getRoles()).orElse(new HashSet())) {
                Collection<String> permissionsByRole = this.permLibrary.getPermissionsByRole(role);
                if (permissionsByRole != null) {
                    perms.addAll(permissionsByRole);
                }
                if (!CollectionUtils.containsSub(permRolesMeta.getExcludePermissions(), permissionsByRole)) continue;
                LogUtils.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                error.error(new Object[]{ExceptionStatus.PERM_EXCEPTION});
                return false;
            }
            if (!CollectionUtils.containsSub(permRolesMeta.getRequirePermissions(), perms)) {
                LogUtils.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                error.error(new Object[]{ExceptionStatus.PERM_EXCEPTION});
                return false;
            }
            httpMeta.setPermissions(perms);
        }
        return true;
    }
}

