/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.schema;

import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.schema.Model;
import cn.omisheep.authz.core.schema.ModelArray;
import cn.omisheep.authz.core.schema.ModelCollection;
import cn.omisheep.authz.core.schema.ModelMember;
import cn.omisheep.authz.core.schema.ModelObject;
import cn.omisheep.authz.core.schema.ResolvedTypes;
import cn.omisheep.authz.core.schema.Types;
import com.fasterxml.classmate.AnnotationConfiguration;
import com.fasterxml.classmate.AnnotationInclusion;
import com.fasterxml.classmate.AnnotationOverrides;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.util.ClassStack;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ModelParser {
    private static final TypeResolver typeResolver = new TypeResolver();
    private static final MemberResolver memberResolver = new MemberResolver(typeResolver);
    private static final AnnotationConfiguration.StdConfiguration stdAnnotationConfiguration = new AnnotationConfiguration.StdConfiguration(AnnotationInclusion.DONT_INCLUDE);
    private static final AnnotationOverrides.StdImpl stdAnnotationOverrides = new AnnotationOverrides.StdImpl(new HashMap());

    private ModelParser() {
        throw new UnsupportedOperationException();
    }

    public static Model parse(Object obj) {
        Objects.requireNonNull(obj, "\u6a21\u578b\u89e3\u6790\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        return ModelParser.parseModel(typeResolver.resolve(obj.getClass(), new Type[0]), null);
    }

    public static Model parse(Class<?> clz) {
        Objects.requireNonNull(clz, "\u6a21\u578b\u89e3\u6790\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return ModelParser.parseModel(typeResolver.resolve(clz, new Type[0]), null);
    }

    public static Model parse(ResolvedType mainType) {
        return ModelParser.parseModel(mainType, null);
    }

    public static Model parse(Object obj, Predicate<Field> filter) {
        Objects.requireNonNull(obj, "\u6a21\u578b\u89e3\u6790\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        return ModelParser.parseModel(typeResolver.resolve(obj.getClass(), new Type[0]), filter);
    }

    public static Model parse(Class<?> clz, Predicate<Field> filter) {
        Objects.requireNonNull(clz, "\u6a21\u578b\u89e3\u6790\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return ModelParser.parseModel(typeResolver.resolve(clz, new Type[0]), filter);
    }

    public static Model parse(ResolvedType mainType, Predicate<Field> filter) {
        return ModelParser.parseModel(mainType, filter);
    }

    public static String simpleTypeName(Class<?> type) {
        return ResolvedTypes.simpleTypeName(typeResolver.resolve(type, new Type[0]));
    }

    public static Class<?> getUserIdType(Object o) {
        try {
            ResolvedType resolve = typeResolver.resolve(o.getClass(), new Type[0]);
            List implementedInterfaces = resolve.getParentClass().getImplementedInterfaces();
            Optional<ResolvedType> first = implementedInterfaces.stream().filter(v -> v.isInstanceOf(PermLibrary.class)).findFirst();
            if (!first.isPresent()) {
                return Object.class;
            }
            return ((ResolvedType)first.get().getTypeParameters().get(0)).getErasedType();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    private static ResolvedTypeWithMembers memberResolve(ResolvedType resolvedType) {
        return memberResolver.resolve(resolvedType, (AnnotationConfiguration)stdAnnotationConfiguration, (AnnotationOverrides)stdAnnotationOverrides);
    }

    private static ModelMember parseMember(ResolvedType mainType, ClassStack classStack, Predicate<Field> filter) {
        ModelMember modelMember;
        block15: {
            block14: {
                modelMember = new ModelMember(ResolvedTypes.simpleTypeName(mainType));
                if (Types.isEnum(mainType)) {
                    if (classStack.find(mainType.getErasedType()) != null) {
                        return modelMember;
                    }
                    String name = ResolvedTypes.simpleTypeName(mainType);
                    Arrays.stream(mainType.getErasedType().getDeclaredFields()).filter(Field::isEnumConstant).forEach(e -> modelMember.members.add(new ModelMember(name, e.getName())));
                    return modelMember;
                }
                classStack = classStack.child(mainType.getErasedType());
                if (Types.isBaseType(mainType)) {
                    return modelMember;
                }
                if (!mainType.isArray()) break block14;
                ResolvedType arrayElementType = mainType.getArrayElementType();
                modelMember.setItem(new ModelObject());
                modelMember.getItem().setTypeName(ResolvedTypes.simpleTypeName(arrayElementType));
                if (Types.isBaseType(arrayElementType)) break block15;
                for (ResolvedField memberField : ModelParser.memberResolve(arrayElementType).getMemberFields()) {
                    ResolvedType fieldType = memberField.getType();
                    Class erasedType = fieldType.getErasedType();
                    if (filter != null && filter.test((Field)memberField.getRawMember())) continue;
                    if (classStack.find(erasedType) != null || Types.isBaseType(fieldType)) {
                        modelMember.members.add(new ModelMember(ResolvedTypes.simpleTypeName(fieldType), memberField.getName()));
                        continue;
                    }
                    modelMember.members.add(ModelParser.parseMember(fieldType, classStack, filter).setMemberName(memberField.getName()));
                }
                break block15;
            }
            if (mainType.isInstanceOf(Collection.class)) {
                if (mainType.getTypeParameters().size() == 0) {
                    return modelMember;
                }
                ResolvedType resolvedType = (ResolvedType)mainType.getTypeParameters().get(0);
                if (classStack.find(resolvedType.getErasedType()) != null) {
                    return modelMember;
                }
                ClassStack child = classStack.child(resolvedType.getErasedType());
                modelMember.setItem(new ModelObject());
                if (Types.isBaseType(mainType) || Types.isVoid(mainType) || mainType.getErasedType().getTypeName().startsWith("java.")) {
                    modelMember.getItem().typeName = ResolvedTypes.simpleTypeName(resolvedType);
                    return modelMember;
                }
                for (ResolvedField memberField : ModelParser.memberResolve(resolvedType).getMemberFields()) {
                    ResolvedType fieldType = memberField.getType();
                    Class erasedType = fieldType.getErasedType();
                    if (filter != null && filter.test((Field)memberField.getRawMember())) continue;
                    if (child.find(erasedType) != null || Types.isBaseType(fieldType)) {
                        modelMember.getItem().getMembers().add(new ModelMember(ResolvedTypes.simpleTypeName(fieldType), memberField.getName()));
                        continue;
                    }
                    modelMember.getItem().getMembers().add(ModelParser.parseMember(fieldType, child, filter).setTypeName(memberField.getName()));
                }
            } else {
                for (ResolvedField memberField : ModelParser.memberResolve(mainType).getMemberFields()) {
                    ResolvedType fieldType = memberField.getType();
                    Class erasedType = fieldType.getErasedType();
                    if (filter != null && filter.test((Field)memberField.getRawMember())) continue;
                    if (classStack.find(erasedType) != null || Types.isBaseType(fieldType)) {
                        modelMember.members.add(new ModelMember(ResolvedTypes.simpleTypeName(fieldType), memberField.getName()));
                        continue;
                    }
                    modelMember.members.add(ModelParser.parseMember(fieldType, classStack, filter).setMemberName(memberField.getName()));
                }
            }
        }
        return modelMember;
    }

    private static ModelArray parseModelArray(ResolvedType mainType, Predicate<Field> filter) {
        ModelArray modelArray = new ModelArray();
        ResolvedType arrayElementType = mainType.getArrayElementType();
        Class arrayElementTypeErasedType = arrayElementType.getErasedType();
        ClassStack classStack = new ClassStack(arrayElementTypeErasedType);
        modelArray.getItem().setTypeName(ResolvedTypes.simpleTypeName(arrayElementType));
        if (Types.isBaseType(arrayElementType)) {
            return modelArray;
        }
        for (ResolvedField memberField : ModelParser.memberResolve(arrayElementType).getMemberFields()) {
            ResolvedType fieldType = memberField.getType();
            Class erasedType = fieldType.getErasedType();
            if (filter != null && filter.test((Field)memberField.getRawMember())) continue;
            if (classStack.find(erasedType) != null || Types.isBaseType(fieldType)) {
                modelArray.getItem().members.add(new ModelMember(ResolvedTypes.simpleTypeName(fieldType), memberField.getName()));
                continue;
            }
            modelArray.getItem().members.add(ModelParser.parseMember(fieldType, classStack, filter).setMemberName(memberField.getName()));
        }
        return modelArray;
    }

    private static ModelCollection parseModelCollection(ResolvedType mainType, Predicate<Field> filter) {
        ModelCollection modelCollection = new ModelCollection(ResolvedTypes.simpleTypeName(mainType));
        if (mainType.getTypeParameters().size() == 0) {
            return modelCollection;
        }
        ResolvedType resolvedType = (ResolvedType)mainType.getTypeParameters().get(0);
        Class parameterErasedType = resolvedType.getErasedType();
        ClassStack classStack = new ClassStack(parameterErasedType);
        modelCollection.getItem().setTypeName(ResolvedTypes.simpleTypeName(resolvedType));
        if (Types.isBaseType(resolvedType)) {
            return modelCollection;
        }
        for (ResolvedField memberField : ModelParser.memberResolve(resolvedType).getMemberFields()) {
            ResolvedType fieldType = memberField.getType();
            Class erasedType = fieldType.getErasedType();
            if (filter != null && filter.test((Field)memberField.getRawMember())) continue;
            if (classStack.find(erasedType) != null || Types.isBaseType(fieldType)) {
                modelCollection.getItem().members.add(new ModelMember(ResolvedTypes.simpleTypeName(fieldType), memberField.getName()));
                continue;
            }
            modelCollection.getItem().members.add(ModelParser.parseMember(fieldType, classStack, filter).setMemberName(memberField.getName()));
        }
        return modelCollection;
    }

    private static ModelObject parseModelObject(ResolvedType mainType, Predicate<Field> filter) {
        Class mainTypeErasedType = mainType.getErasedType();
        ClassStack classStack = new ClassStack(mainTypeErasedType);
        ModelObject modelObject = new ModelObject(ResolvedTypes.simpleTypeName(mainType));
        for (ResolvedField memberField : ModelParser.memberResolve(mainType).getMemberFields()) {
            ResolvedType fieldType = memberField.getType();
            if (filter != null && filter.test((Field)memberField.getRawMember())) continue;
            Class erasedType = fieldType.getErasedType();
            if (classStack.find(erasedType) != null || Types.isBaseType(fieldType)) {
                modelObject.members.add(new ModelMember(ResolvedTypes.simpleTypeName(fieldType), memberField.getName()));
                continue;
            }
            modelObject.members.add(ModelParser.parseMember(fieldType, classStack, filter).setMemberName(memberField.getName()));
        }
        return modelObject;
    }

    private static Model parseModel(ResolvedType mainType, Predicate<Field> filter) {
        if (Types.isBaseType(mainType) || Types.isVoid(mainType) || mainType.getErasedType().getTypeName().startsWith("java.")) {
            return new Model(ResolvedTypes.simpleTypeName(mainType));
        }
        if (mainType.isArray()) {
            return ModelParser.parseModelArray(mainType, filter);
        }
        if (mainType.isInstanceOf(Collection.class)) {
            return ModelParser.parseModelCollection(mainType, filter);
        }
        return ModelParser.parseModelObject(mainType, filter);
    }
}

