/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.resolver;

import cn.omisheep.authz.core.codec.DecryptHandler;
import cn.omisheep.authz.core.interceptor.AuthzExceptionHandler;
import cn.omisheep.authz.core.interceptor.AuthzSlotCoreInterceptor;
import cn.omisheep.authz.core.resolver.AuHttpMetaResolver;
import cn.omisheep.authz.core.resolver.AuTokenOrHttpMetaResolver;
import cn.omisheep.authz.core.resolver.DecryptRequestParamHandler;
import cn.omisheep.authz.core.slot.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class AuthzHandlerRegister
implements WebMvcConfigurer,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AuthzHandlerRegister.class);
    private final AuthzExceptionHandler authzExceptionHandler;
    private final DecryptHandler decryptHandler;
    private Collection<Slot> slots = new ArrayList<Slot>();

    public AuthzHandlerRegister(AuthzExceptionHandler authzExceptionHandler, DecryptHandler decryptHandler) {
        this.authzExceptionHandler = authzExceptionHandler;
        this.decryptHandler = decryptHandler;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuthzSlotCoreInterceptor(this.authzExceptionHandler, this.slots)).excludePathPatterns(new String[]{"/error"}).order(1);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new AuTokenOrHttpMetaResolver());
        resolvers.add(new AuHttpMetaResolver());
        resolvers.add(new DecryptRequestParamHandler(this.decryptHandler));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map result = applicationContext.getBeansOfType(Slot.class);
        this.slots = result.values();
    }
}

