/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.oauth;

import cn.omisheep.authz.annotation.OAuthScope;
import cn.omisheep.authz.annotation.OAuthScopeBasic;
import cn.omisheep.authz.core.auth.rpd.Non;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.tk.GrantType;
import cn.omisheep.authz.core.util.MetaUtils;
import cn.omisheep.web.entity.Result;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class OpenAuthDict {
    private static final Map<String, Map<String, OAuthInfo>> _src = new HashMap<String, Map<String, OAuthInfo>>();
    private static final Map<String, Map<String, OAuthInfo>> src = Collections.unmodifiableMap(_src);

    public static boolean target(String path, String method, GrantType type, Set<String> scope) {
        Map<String, OAuthInfo> p = src.get(path);
        if (p == null) {
            return false;
        }
        OAuthInfo authInfo = p.get(method);
        if (authInfo == null || authInfo.non()) {
            return false;
        }
        if (!authInfo.type.contains((Object)type)) {
            return false;
        }
        return scope.containsAll(authInfo.scope);
    }

    public static void init(ApplicationContext applicationContext, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        HashMap cMap = new HashMap();
        HashMap gMap = new HashMap();
        String defaultBasicScope = AuthzAppVersion.properties.getOauth().getDefaultBasicScope();
        applicationContext.getBeansWithAnnotation(OAuthScope.class).forEach((key, value) -> {
            OAuthScope oAuthScope = MetaUtils.getAnnotation(value, OAuthScope.class);
            if (oAuthScope == null) {
                return;
            }
            cMap.computeIfAbsent(key, r -> new HashSet()).addAll(Arrays.asList(oAuthScope.scope()));
            gMap.computeIfAbsent(key, r -> new HashSet()).addAll(Arrays.asList(oAuthScope.type()));
        });
        applicationContext.getBeansWithAnnotation(OAuthScopeBasic.class).forEach((key, value) -> {
            OAuthScopeBasic oAuthScopeBasic = MetaUtils.getAnnotation(value, OAuthScopeBasic.class);
            if (oAuthScopeBasic == null) {
                return;
            }
            Set l = cMap.computeIfAbsent(key, r -> new HashSet());
            l.addAll(Arrays.asList(oAuthScopeBasic.scope()));
            l.add(defaultBasicScope);
            gMap.computeIfAbsent(key, r -> new HashSet()).addAll(Arrays.asList(oAuthScopeBasic.type()));
        });
        mapRet.forEach((key, value) -> {
            OAuthScopeBasic oAuthScopeBasic;
            List mtds = key.getMethodsCondition().getMethods().stream().map(Enum::name).collect(Collectors.toList());
            Set<String> patterns = MetaUtils.getPatterns(key);
            HashSet<String> scope = new HashSet<String>(cMap.getOrDefault((String)value.getBean(), new HashSet()));
            HashSet<GrantType> type = new HashSet<GrantType>(gMap.getOrDefault((String)value.getBean(), new HashSet()));
            OAuthScope oAuthScope = (OAuthScope)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)value.getMethod(), OAuthScope.class);
            if (oAuthScope != null) {
                scope.addAll(Arrays.asList(oAuthScope.scope()));
                type.addAll(Arrays.asList(oAuthScope.type()));
            }
            if ((oAuthScopeBasic = (OAuthScopeBasic)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)value.getMethod(), OAuthScopeBasic.class)) != null) {
                scope.addAll(Arrays.asList(oAuthScopeBasic.scope()));
                scope.add(defaultBasicScope);
                type.addAll(Arrays.asList(oAuthScopeBasic.type()));
            }
            if (scope.isEmpty() && type.isEmpty()) {
                return;
            }
            patterns.forEach(pattern -> mtds.forEach(method -> {
                OAuthInfo authInfo = _src.computeIfAbsent((String)pattern, r -> new HashMap()).computeIfAbsent(method, r -> new OAuthInfo());
                authInfo.scope.addAll(scope);
                authInfo.type.addAll(type);
            }));
        });
    }

    @Nullable
    public static Object modify(@NonNull AuthzModifier modifier) {
        if (modifier.getTarget() != AuthzModifier.Target.OPEN_AUTH) {
            return Result.FAIL.data();
        }
        switch (modifier.getOperate()) {
            case READ: 
            case GET: {
                return src;
            }
            case ADD: 
            case UPDATE: 
            case MODIFY: {
                OAuthInfo oauth = modifier.getOauth();
                if (oauth == null) {
                    return Result.SUCCESS;
                }
                _src.computeIfAbsent(modifier.getApi(), r -> new HashMap()).put(modifier.getMethod(), oauth);
                return Result.SUCCESS;
            }
            case DELETE: 
            case DEL: {
                Map<String, OAuthInfo> map = _src.get(modifier.getApi());
                if (map != null) {
                    map.remove(modifier.getMethod());
                    if (map.isEmpty()) {
                        _src.remove(modifier.getApi());
                    }
                }
                return Result.SUCCESS;
            }
        }
        return Result.SUCCESS;
    }

    private OpenAuthDict() {
        throw new UnsupportedOperationException();
    }

    public static Map<String, Map<String, OAuthInfo>> getSrc() {
        return src;
    }

    public static class OAuthInfo
    implements Non {
        private Set<String> scope = new HashSet<String>();
        private Set<GrantType> type = new HashSet<GrantType>();

        @Override
        public boolean non() {
            return this.scope.isEmpty() && this.type.isEmpty();
        }

        public Set<String> getScope() {
            return this.scope;
        }

        public Set<GrantType> getType() {
            return this.type;
        }

        public OAuthInfo setScope(Set<String> scope) {
            this.scope = scope;
            return this;
        }

        public OAuthInfo setType(Set<GrantType> type) {
            this.type = type;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuthInfo)) {
                return false;
            }
            OAuthInfo other = (OAuthInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$scope = this.getScope();
            Set<String> other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
                return false;
            }
            Set<GrantType> this$type = this.getType();
            Set<GrantType> other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OAuthInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
            Set<GrantType> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAuthDict.OAuthInfo(scope=" + this.getScope() + ", type=" + this.getType() + ")";
        }
    }
}

