/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.oauth;

import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.oauth.AuthorizationInfo;
import cn.omisheep.authz.core.tk.GrantType;
import java.util.Date;

public class AuthorizedDeviceDetails {
    private String authorizedDeviceId;
    private Object userId;
    private String clientId;
    private GrantType grantType;
    private String scope;
    private Date authorizedDate;
    private Date expiresDate;

    public AuthorizedDeviceDetails(Device device, Object userId, String authorizedDeviceId) {
        this.authorizedDeviceId = authorizedDeviceId;
        this.userId = userId;
        this.clientId = device.getClientId();
        this.grantType = device.getGrantType();
        this.scope = device.getScope();
        this.authorizedDate = device.getAuthorizedDate();
        this.expiresDate = device.getExpiresDate();
    }

    public AuthorizedDeviceDetails(AuthorizationInfo authorizationInfo, String authorizedDeviceId) {
        this.userId = authorizationInfo.getUserId();
        this.clientId = authorizationInfo.getClientId();
        this.grantType = authorizationInfo.getGrantType();
        this.scope = authorizationInfo.getScope();
        if (authorizationInfo.getAuthorizedAt() != null) {
            this.authorizedDate = new Date(authorizationInfo.getAuthorizedAt());
        }
        if (authorizationInfo.getExpiresAt() != null) {
            this.expiresDate = new Date(authorizationInfo.getExpiresAt());
        }
        this.authorizedDeviceId = authorizedDeviceId;
    }

    public String getAuthorizedDeviceId() {
        return this.authorizedDeviceId;
    }

    public Object getUserId() {
        return this.userId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public Date getAuthorizedDate() {
        return this.authorizedDate;
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public void setAuthorizedDeviceId(String authorizedDeviceId) {
        this.authorizedDeviceId = authorizedDeviceId;
    }

    public void setUserId(Object userId) {
        this.userId = userId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAuthorizedDate(Date authorizedDate) {
        this.authorizedDate = authorizedDate;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizedDeviceDetails)) {
            return false;
        }
        AuthorizedDeviceDetails other = (AuthorizedDeviceDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authorizedDeviceId = this.getAuthorizedDeviceId();
        String other$authorizedDeviceId = other.getAuthorizedDeviceId();
        if (this$authorizedDeviceId == null ? other$authorizedDeviceId != null : !this$authorizedDeviceId.equals(other$authorizedDeviceId)) {
            return false;
        }
        Object this$userId = this.getUserId();
        Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        GrantType this$grantType = this.getGrantType();
        GrantType other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !((Object)((Object)this$grantType)).equals((Object)other$grantType)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        Date this$authorizedDate = this.getAuthorizedDate();
        Date other$authorizedDate = other.getAuthorizedDate();
        if (this$authorizedDate == null ? other$authorizedDate != null : !((Object)this$authorizedDate).equals(other$authorizedDate)) {
            return false;
        }
        Date this$expiresDate = this.getExpiresDate();
        Date other$expiresDate = other.getExpiresDate();
        return !(this$expiresDate == null ? other$expiresDate != null : !((Object)this$expiresDate).equals(other$expiresDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthorizedDeviceDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorizedDeviceId = this.getAuthorizedDeviceId();
        result = result * 59 + ($authorizedDeviceId == null ? 43 : $authorizedDeviceId.hashCode());
        Object $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        GrantType $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : ((Object)((Object)$grantType)).hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        Date $authorizedDate = this.getAuthorizedDate();
        result = result * 59 + ($authorizedDate == null ? 43 : ((Object)$authorizedDate).hashCode());
        Date $expiresDate = this.getExpiresDate();
        result = result * 59 + ($expiresDate == null ? 43 : ((Object)$expiresDate).hashCode());
        return result;
    }

    public String toString() {
        return "AuthorizedDeviceDetails(authorizedDeviceId=" + this.getAuthorizedDeviceId() + ", userId=" + this.getUserId() + ", clientId=" + this.getClientId() + ", grantType=" + (Object)((Object)this.getGrantType()) + ", scope=" + this.getScope() + ", authorizedDate=" + this.getAuthorizedDate() + ", expiresDate=" + this.getExpiresDate() + ")";
    }
}

