/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.msg;

import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.msg.Message;
import java.util.List;
import java.util.Objects;

public class VersionMessage
implements Message {
    public static String CHANNEL;
    private String id = Message.uuid;
    private String context = CHANNEL;
    private int version;
    private AuthzModifier authzModifier;
    private List<AuthzModifier> authzModifierList;
    private String md5;
    private boolean tag = false;

    public VersionMessage() {
    }

    public VersionMessage(int version) {
        this.version = version;
        if (AuthzAppVersion.isMd5check()) {
            this.md5 = AuthzAppVersion.getJarMd5();
        }
    }

    public VersionMessage(AuthzModifier authzModifier, int version) {
        this.authzModifier = authzModifier;
        this.version = version;
        if (AuthzAppVersion.isMd5check()) {
            this.md5 = AuthzAppVersion.getJarMd5();
        }
    }

    public VersionMessage(List<AuthzModifier> changelog, int version) {
        this.authzModifierList = changelog;
        this.version = version;
        if (AuthzAppVersion.isMd5check()) {
            this.md5 = AuthzAppVersion.getJarMd5();
        }
    }

    public static boolean ignore(VersionMessage message) {
        return message == null || Message.uuid.equals(message.getId()) || !message.context.equals(CHANNEL) || VersionMessage.failureMd5Check(message);
    }

    private static boolean failureMd5Check(VersionMessage message) {
        if (AuthzAppVersion.isMd5check()) {
            return !Objects.equals(message.md5, AuthzAppVersion.getJarMd5());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getContext() {
        return this.context;
    }

    public int getVersion() {
        return this.version;
    }

    public AuthzModifier getAuthzModifier() {
        return this.authzModifier;
    }

    public List<AuthzModifier> getAuthzModifierList() {
        return this.authzModifierList;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean isTag() {
        return this.tag;
    }

    public VersionMessage setId(String id) {
        this.id = id;
        return this;
    }

    public VersionMessage setContext(String context) {
        this.context = context;
        return this;
    }

    public VersionMessage setVersion(int version) {
        this.version = version;
        return this;
    }

    public VersionMessage setAuthzModifier(AuthzModifier authzModifier) {
        this.authzModifier = authzModifier;
        return this;
    }

    public VersionMessage setAuthzModifierList(List<AuthzModifier> authzModifierList) {
        this.authzModifierList = authzModifierList;
        return this;
    }

    public VersionMessage setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    public VersionMessage setTag(boolean tag) {
        this.tag = tag;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionMessage)) {
            return false;
        }
        VersionMessage other = (VersionMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isTag() != other.isTag()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        AuthzModifier this$authzModifier = this.getAuthzModifier();
        AuthzModifier other$authzModifier = other.getAuthzModifier();
        if (this$authzModifier == null ? other$authzModifier != null : !((Object)this$authzModifier).equals(other$authzModifier)) {
            return false;
        }
        List<AuthzModifier> this$authzModifierList = this.getAuthzModifierList();
        List<AuthzModifier> other$authzModifierList = other.getAuthzModifierList();
        if (this$authzModifierList == null ? other$authzModifierList != null : !((Object)this$authzModifierList).equals(other$authzModifierList)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isTag() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        AuthzModifier $authzModifier = this.getAuthzModifier();
        result = result * 59 + ($authzModifier == null ? 43 : ((Object)$authzModifier).hashCode());
        List<AuthzModifier> $authzModifierList = this.getAuthzModifierList();
        result = result * 59 + ($authzModifierList == null ? 43 : ((Object)$authzModifierList).hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        return result;
    }

    public String toString() {
        return "VersionMessage(id=" + this.getId() + ", context=" + this.getContext() + ", version=" + this.getVersion() + ", authzModifier=" + this.getAuthzModifier() + ", authzModifierList=" + this.getAuthzModifierList() + ", md5=" + this.getMd5() + ", tag=" + this.isTag() + ")";
    }
}

