/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.msg;

import cn.omisheep.authz.AuthzAutoConfiguration;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.msg.CacheMessage;
import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.authz.core.msg.RequestMessage;
import cn.omisheep.authz.core.msg.VersionMessage;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.TimeUtils;

public class MessageReceive {
    private final Cache cache;

    public MessageReceive(Cache cache) {
        this.cache = cache;
    }

    public void handleMessage(String o) {
        VersionMessage message;
        Object oo = AuthzAutoConfiguration.CacheAutoConfiguration.jackson2JsonRedisSerializer.deserialize(o.getBytes());
        if (oo == null || !(oo instanceof Message)) {
            return;
        }
        if (oo instanceof CacheMessage) {
            CacheMessage message2 = (CacheMessage)oo;
            if (!CacheMessage.ignore(message2)) {
                LogUtils.debug("MessageReceive time: {} message: {}", TimeUtils.nowTime(), message2);
                this.cache.receive(message2);
            }
        } else if (oo instanceof RequestMessage) {
            RequestMessage message3 = (RequestMessage)oo;
            if (!RequestMessage.ignore(message3)) {
                LogUtils.debug("RequestMessage time: {} message: {}", TimeUtils.nowTime(), message3);
                Httpd.receive(message3);
            }
        } else if (oo instanceof VersionMessage && !VersionMessage.ignore(message = (VersionMessage)oo)) {
            LogUtils.debug("VersionMessage time: {} message: {}", TimeUtils.nowTime(), message);
            AuthzAppVersion.receive(message);
        }
    }
}

